/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.invoker.base;

import com.greedystar.generator.db.ConnectionUtil;
import com.greedystar.generator.entity.ColumnInfo;
import com.greedystar.generator.invoker.base.Invoker;
import com.greedystar.generator.task.base.AbstractTask;
import com.greedystar.generator.utils.TaskQueue;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractInvoker
implements Invoker {
    protected String tableName;
    protected String className;
    protected String parentTableName;
    protected String parentClassName;
    protected String foreignKey;
    protected String relationalTableName;
    protected String parentForeignKey;
    protected List<ColumnInfo> tableInfos;
    protected List<ColumnInfo> parentTableInfos;
    protected ConnectionUtil connectionUtil = new ConnectionUtil();
    protected TaskQueue taskQueue = new TaskQueue();
    private ExecutorService executorPool = Executors.newFixedThreadPool(6);

    protected abstract void queryMetaData() throws Exception;

    protected abstract void initTasks();

    @Override
    public void execute() {
        try {
            this.queryMetaData();
            this.initTasks();
            while (!this.taskQueue.isEmpty()) {
                AbstractTask task = this.taskQueue.poll();
                this.executorPool.execute(() -> {
                    try {
                        task.run();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (TemplateException e) {
                        e.printStackTrace();
                    }
                });
            }
            this.executorPool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setParentTableName(String parentTableName) {
        this.parentTableName = parentTableName;
    }

    public void setParentClassName(String parentClassName) {
        this.parentClassName = parentClassName;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public void setRelationalTableName(String relationalTableName) {
        this.relationalTableName = relationalTableName;
    }

    public void setParentForeignKey(String parentForeignKey) {
        this.parentForeignKey = parentForeignKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParentTableName() {
        return this.parentTableName;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public String getRelationalTableName() {
        return this.relationalTableName;
    }

    public String getParentForeignKey() {
        return this.parentForeignKey;
    }

    public List<ColumnInfo> getTableInfos() {
        return this.tableInfos;
    }

    public void setTableInfos(List<ColumnInfo> tableInfos) {
        this.tableInfos = tableInfos;
    }

    public List<ColumnInfo> getParentTableInfos() {
        return this.parentTableInfos;
    }

    public void setParentTableInfos(List<ColumnInfo> parentTableInfos) {
        this.parentTableInfos = parentTableInfos;
    }
}

