/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.task;

import com.greedystar.generator.entity.ColumnInfo;
import com.greedystar.generator.invoker.base.AbstractInvoker;
import com.greedystar.generator.task.base.AbstractTask;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.FileUtil;
import com.greedystar.generator.utils.StringUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class ControllerTask
extends AbstractTask {
    public ControllerTask(AbstractInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public void run() throws IOException, TemplateException {
        String serviceImport;
        String serviceClassName;
        HashMap<String, Object> controllerData = new HashMap<String, Object>();
        controllerData.put("Configuration", ConfigUtil.getConfiguration());
        if (StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getInterf())) {
            serviceClassName = ConfigUtil.getConfiguration().getName().getService().replace("$s", this.invoker.getClassName());
            serviceImport = String.format("import %s.%s.%s;", ConfigUtil.getConfiguration().getPackageName(), ConfigUtil.getConfiguration().getPath().getService(), serviceClassName);
        } else {
            serviceClassName = ConfigUtil.getConfiguration().getName().getInterf().replace("$s", this.invoker.getClassName());
            serviceImport = String.format("import %s.%s.%s;", ConfigUtil.getConfiguration().getPackageName(), ConfigUtil.getConfiguration().getPath().getInterf(), serviceClassName);
        }
        controllerData.put("ServiceImport", serviceImport);
        controllerData.put("ServiceClassName", serviceClassName);
        controllerData.put("ServiceEntityName", StringUtil.firstToLowerCase(serviceClassName));
        controllerData.put("ControllerClassName", ConfigUtil.getConfiguration().getName().getController().replace("$s", this.invoker.getClassName()));
        controllerData.put("ClassName", ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getClassName()));
        controllerData.put("EntityName", StringUtil.firstToLowerCase(ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getClassName())));
        controllerData.put("pkType", this.getPrimaryKeyType(this.invoker.getTableInfos()));
        String filePath = FileUtil.getSourcePath() + StringUtil.package2Path(ConfigUtil.getConfiguration().getPackageName()) + StringUtil.package2Path(ConfigUtil.getConfiguration().getPath().getController());
        String fileName = ConfigUtil.getConfiguration().getName().getController().replace("$s", this.invoker.getClassName()) + ".java";
        FileUtil.generateToJava(3, controllerData, filePath, fileName);
    }

    private String getPrimaryKeyType(List<ColumnInfo> columnInfos) {
        if (!ConfigUtil.getConfiguration().isJpaEnable()) {
            return "Serializable";
        }
        for (ColumnInfo info : columnInfos) {
            if (!info.isPrimaryKey()) continue;
            return info.getPropertyType();
        }
        return "Serializable";
    }
}

