/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.task;

import com.greedystar.generator.entity.ColumnInfo;
import com.greedystar.generator.entity.IdStrategy;
import com.greedystar.generator.entity.Mode;
import com.greedystar.generator.invoker.base.AbstractInvoker;
import com.greedystar.generator.task.base.AbstractTask;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.FileUtil;
import com.greedystar.generator.utils.ForEachUtil;
import com.greedystar.generator.utils.StringUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class EntityTask
extends AbstractTask {
    private List<ColumnInfo> tableInfos;
    private Mode mode;

    public EntityTask(Mode mode, AbstractInvoker invoker) {
        this.mode = mode;
        this.invoker = invoker;
        if (Mode.ENTITY_MAIN.equals((Object)mode)) {
            this.tableInfos = invoker.getTableInfos();
        } else if (Mode.ENTITY_PARENT.equals((Object)mode)) {
            this.tableInfos = invoker.getParentTableInfos();
        }
    }

    @Override
    public void run() throws IOException, TemplateException {
        String className = null;
        String remarks = null;
        if (Mode.ENTITY_MAIN.equals((Object)this.mode)) {
            className = ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getClassName());
            remarks = this.invoker.getTableInfos().get(0).getTableRemarks();
        } else if (Mode.ENTITY_PARENT.equals((Object)this.mode)) {
            className = ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getParentClassName());
            remarks = this.invoker.getParentTableInfos().get(0).getTableRemarks();
        }
        HashMap<String, Object> entityData = new HashMap<String, Object>();
        entityData.put("Configuration", ConfigUtil.getConfiguration());
        entityData.put("TableName", this.invoker.getTableName());
        entityData.put("ClassName", className);
        entityData.put("Remarks", remarks);
        entityData.put("Properties", this.entityProperties(this.invoker));
        entityData.put("Methods", this.entityMethods(this.invoker));
        String filePath = FileUtil.getSourcePath() + StringUtil.package2Path(ConfigUtil.getConfiguration().getPackageName()) + StringUtil.package2Path(ConfigUtil.getConfiguration().getPath().getEntity());
        String fileName = ConfigUtil.getConfiguration().getName().getEntity().replace("$s", className) + ".java";
        FileUtil.generateToJava(0, entityData, filePath, fileName);
    }

    public String entityProperties(AbstractInvoker invoker) {
        StringBuilder sb = new StringBuilder();
        this.tableInfos.forEach(ForEachUtil.withIndex((info, index) -> {
            if (info.getColumnName().equals(invoker.getForeignKey())) {
                return;
            }
            sb.append(index == 0 ? "" : "    ");
            this.generateRemarks(sb, (ColumnInfo)info);
            this.generateORMAnnotation(sb, (ColumnInfo)info);
            sb.append("    ").append(String.format("private %s %s;\n", info.getPropertyType(), info.getPropertyName()));
            sb.append("\n");
        }));
        if (Mode.ENTITY_PARENT.equals((Object)this.mode)) {
            return sb.toString();
        }
        if (!StringUtil.isEmpty(invoker.getRelationalTableName()) || !StringUtil.isEmpty(invoker.getParentForeignKey())) {
            sb.append("    ").append(String.format("private List<%s> %ss;\n", invoker.getParentClassName(), StringUtil.firstToLowerCase(invoker.getParentClassName())));
            sb.append("\n");
        } else if (!StringUtil.isEmpty(invoker.getForeignKey())) {
            sb.append("    ").append(String.format("private %s %s;\n", invoker.getParentClassName(), StringUtil.firstToLowerCase(invoker.getParentClassName())));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String entityMethods(AbstractInvoker invoker) {
        if (ConfigUtil.getConfiguration().isLombokEnable()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.tableInfos.forEach(ForEachUtil.withIndex((info, index) -> {
            if (info.getColumnName().equals(invoker.getForeignKey())) {
                return;
            }
            String setter = String.format("public void set%s (%s %s) { this.%s = %s; } \n\n", StringUtil.firstToUpperCase(info.getPropertyName()), info.getPropertyType(), info.getPropertyName(), info.getPropertyName(), info.getPropertyName());
            sb.append(index == 0 ? "" : "    ").append(setter);
            String getter = null;
            getter = info.getPropertyType().equals("boolean") || info.getPropertyType().equals("Boolean") ? String.format("public %s is%s () { return this.%s; } \n\n", info.getPropertyType(), StringUtil.firstToUpperCase(info.getPropertyName()), info.getPropertyName()) : String.format("public %s get%s () { return this.%s; } \n\n", info.getPropertyType(), StringUtil.firstToUpperCase(info.getPropertyName()), info.getPropertyName());
            sb.append("    ").append(getter);
        }));
        if (Mode.ENTITY_PARENT.equals((Object)this.mode)) {
            return sb.toString();
        }
        if (!StringUtil.isEmpty(invoker.getRelationalTableName()) || !StringUtil.isEmpty(invoker.getParentForeignKey())) {
            String setter = String.format("public void set%ss (List<%s> %ss) { this.%ss = %ss; }\n\n", invoker.getParentClassName(), invoker.getParentClassName(), StringUtil.firstToLowerCase(invoker.getParentClassName()), StringUtil.firstToLowerCase(invoker.getParentClassName()), StringUtil.firstToLowerCase(invoker.getParentClassName()));
            sb.append("    ").append(setter);
            String getter = String.format("public List<%s> get%ss () { return this.%ss; }\n\n", invoker.getParentClassName(), invoker.getParentClassName(), StringUtil.firstToLowerCase(invoker.getParentClassName()));
            sb.append("    ").append(getter);
        } else if (!StringUtil.isEmpty(invoker.getForeignKey())) {
            String setter = String.format("public void set%s (%s %s) { this.%s = %s; }\n\n", invoker.getParentClassName(), invoker.getParentClassName(), StringUtil.firstToLowerCase(invoker.getParentClassName()), StringUtil.firstToLowerCase(invoker.getParentClassName()), StringUtil.firstToLowerCase(invoker.getParentClassName()));
            sb.append("    ").append(setter);
            String getter = String.format("public %s get%s () { return this.%s; }\n\n", invoker.getParentClassName(), invoker.getParentClassName(), StringUtil.firstToLowerCase(invoker.getParentClassName()));
            sb.append("    ").append(getter);
        }
        return sb.toString();
    }

    public void generateRemarks(StringBuilder sb, ColumnInfo info) {
        sb.append("/**").append("\n");
        sb.append("    ").append(" * ").append(info.getRemarks()).append("\n");
        sb.append("    ").append(" */").append("\n");
    }

    public void generateSwaggerAnnotation(StringBuilder sb, ColumnInfo info) {
        if (!ConfigUtil.getConfiguration().isSwaggerEnable()) {
            return;
        }
        sb.append(String.format("@ApiModelProperty(value = \"%s\", dataType = \"%s\")", info.getRemarks(), info.getPropertyType()));
        sb.append("\n");
    }

    public void generateORMAnnotation(StringBuilder sb, ColumnInfo info) {
        if (ConfigUtil.getConfiguration().isMybatisPlusEnable()) {
            if (info.isPrimaryKey()) {
                if (ConfigUtil.getConfiguration().getIdStrategy() == null || ConfigUtil.getConfiguration().getIdStrategy() == IdStrategy.AUTO) {
                    sb.append("    ").append(String.format("@TableId(value = \"%s\", type = IdType.AUTO)\n", info.getColumnName()));
                } else if (ConfigUtil.getConfiguration().getIdStrategy() == IdStrategy.UUID) {
                    sb.append("    ").append(String.format("@TableId(value = \"%s\", type = IdType.ASSIGN_UUID)\n", info.getColumnName()));
                }
            } else {
                sb.append("    ").append(String.format("@TableField(value = \"%s\")\n", info.getColumnName()));
            }
        } else if (ConfigUtil.getConfiguration().isJpaEnable()) {
            if (info.isPrimaryKey()) {
                if (ConfigUtil.getConfiguration().getIdStrategy() == null || ConfigUtil.getConfiguration().getIdStrategy() == IdStrategy.AUTO) {
                    sb.append("    ").append("@Id\n");
                    sb.append("    ").append("@GeneratedValue(strategy = GenerationType.IDENTITY)\n");
                } else if (ConfigUtil.getConfiguration().getIdStrategy() == IdStrategy.UUID) {
                    sb.append("    ").append("@Id\n");
                    sb.append("    ").append("@GeneratedValue(generator = \"uuidGenerator\")\n");
                    sb.append("    ").append("@GenericGenerator(name = \"uuidGenerator\", strategy = \"uuid\")\n");
                }
            }
            sb.append("    ").append(String.format("@Column(name = \"%s\")\n", info.getColumnName()));
        }
    }
}

