/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.task;

import com.greedystar.generator.entity.ColumnInfo;
import com.greedystar.generator.invoker.base.AbstractInvoker;
import com.greedystar.generator.task.base.AbstractTask;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.FileUtil;
import com.greedystar.generator.utils.ForEachUtil;
import com.greedystar.generator.utils.StringUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class MapperTask
extends AbstractTask {
    public MapperTask(AbstractInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public void run() throws IOException, TemplateException {
        HashMap<String, Object> mapperData = new HashMap<String, Object>();
        mapperData.put("Configuration", ConfigUtil.getConfiguration());
        mapperData.put("ClassName", ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getClassName()));
        mapperData.put("EntityName", StringUtil.firstToLowerCase(ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getClassName())));
        mapperData.put("DaoClassName", ConfigUtil.getConfiguration().getName().getDao().replace("$s", this.invoker.getClassName()));
        mapperData.put("TableName", this.invoker.getTableName());
        mapperData.put("PrimaryKey", this.getPrimaryKeyColumnInfo(this.invoker.getTableInfos()).getColumnName());
        mapperData.put("WhereId", "#{" + this.getPrimaryKeyColumnInfo(this.invoker.getTableInfos()).getPropertyName() + "}");
        mapperData.put("PrimaryColumn", this.getPrimaryKeyColumnInfo(this.invoker.getTableInfos()));
        mapperData.put("InsertProperties", this.insertProperties());
        mapperData.put("ColumnMap", this.columnMap());
        mapperData.put("ResultMap", this.resultMap());
        mapperData.put("InsertBatchValues", this.insertBatchValues());
        mapperData.put("InsertValues", this.insertValues());
        mapperData.put("UpdateProperties", this.updateProperties());
        mapperData.put("Joins", this.joins());
        if (!StringUtil.isEmpty(this.invoker.getRelationalTableName())) {
            mapperData.put("Association", "");
            mapperData.put("Collection", this.collection());
        } else if (!StringUtil.isEmpty(this.invoker.getParentForeignKey())) {
            mapperData.put("Association", "");
            mapperData.put("Collection", this.collection());
        } else if (!StringUtil.isEmpty(this.invoker.getForeignKey())) {
            mapperData.put("Association", this.association());
            mapperData.put("Collection", "");
        } else {
            mapperData.put("Association", "");
            mapperData.put("Collection", "");
        }
        String filePath = ConfigUtil.getConfiguration().isMapperUnderSource() ? FileUtil.getSourcePath() + StringUtil.package2Path(ConfigUtil.getConfiguration().getPackageName()) + StringUtil.package2Path(ConfigUtil.getConfiguration().getPath().getMapper()) : FileUtil.getResourcePath() + StringUtil.package2Path(ConfigUtil.getConfiguration().getPath().getMapper());
        String fileName = ConfigUtil.getConfiguration().getName().getMapper().replace("$s", this.invoker.getClassName()) + ".xml";
        FileUtil.generateToJava(4, mapperData, filePath, fileName);
    }

    private ColumnInfo getPrimaryKeyColumnInfo(List<ColumnInfo> list) {
        for (ColumnInfo columnInfo : list) {
            if (!columnInfo.isPrimaryKey()) continue;
            return columnInfo;
        }
        return null;
    }

    public String columnMap() {
        StringBuilder sb = new StringBuilder();
        this.invoker.getTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            if (info.getColumnName().equals(this.invoker.getForeignKey())) {
                return;
            }
            sb.append(index == 0 ? "" : "        ");
            sb.append(String.format("`%s`.`%s`,\n", this.invoker.getTableName(), info.getColumnName()));
        }));
        if (this.invoker.getParentTableInfos() != null) {
            this.invoker.getParentTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
                sb.append("        ");
                if (!StringUtil.isEmpty(this.invoker.getRelationalTableName()) || !StringUtil.isEmpty(this.invoker.getParentForeignKey())) {
                    sb.append(String.format("`%s`.`%s` AS `%ss.%s`,\n", this.invoker.getParentTableName(), info.getColumnName(), StringUtil.firstToLowerCase(this.invoker.getParentClassName()), info.getColumnName()));
                } else {
                    sb.append(String.format("`%s`.`%s` AS `%s.%s`,\n", this.invoker.getParentTableName(), info.getColumnName(), StringUtil.firstToLowerCase(this.invoker.getParentClassName()), info.getColumnName()));
                }
            }));
        }
        return sb.toString().substring(0, sb.toString().length() - 2);
    }

    public String resultMap() {
        StringBuilder sb = new StringBuilder();
        this.invoker.getTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            if (info.getColumnName().equals(this.invoker.getForeignKey())) {
                return;
            }
            sb.append(index == 0 ? "" : "        ");
            if (info.isPrimaryKey()) {
                sb.append(String.format("<id column=\"%s\" property=\"%s\" />\n", info.getColumnName(), info.getPropertyName()));
            } else {
                sb.append(String.format("<result column=\"%s\" property=\"%s\" />\n", info.getColumnName(), info.getPropertyName()));
            }
        }));
        return sb.toString();
    }

    public String association() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<association property=\"%s\" javaType=\"%s.%s\">\n", StringUtil.firstToLowerCase(this.invoker.getParentClassName()), ConfigUtil.getConfiguration().getPackageName() + "." + ConfigUtil.getConfiguration().getPath().getEntity(), this.invoker.getParentClassName()));
        this.invoker.getParentTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            if (info.isPrimaryKey()) {
                sb.append("            ").append(String.format("<id column=\"%s.%s\" property=\"%s\" />\n", StringUtil.firstToLowerCase(this.invoker.getParentClassName()), info.getColumnName(), info.getPropertyName()));
            } else {
                sb.append("            ").append(String.format("<result column=\"%s.%s\" property=\"%s\" />\n", StringUtil.firstToLowerCase(this.invoker.getParentClassName()), info.getColumnName(), info.getPropertyName()));
            }
        }));
        sb.append("        ").append("</association>");
        return sb.toString();
    }

    public String collection() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<collection property=\"%ss\" ofType=\"%s.%s\" >\n ", StringUtil.firstToLowerCase(this.invoker.getParentClassName()), ConfigUtil.getConfiguration().getPackageName() + "." + ConfigUtil.getConfiguration().getPath().getEntity(), this.invoker.getParentClassName()));
        this.invoker.getParentTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            if (info.isPrimaryKey()) {
                sb.append("            ").append(String.format("<id column=\"%ss.%s\" property=\"%s\" />\n", StringUtil.firstToLowerCase(this.invoker.getParentClassName()), info.getColumnName(), info.getPropertyName()));
            } else {
                sb.append("            ").append(String.format("<result column=\"%ss.%s\" property=\"%s\" />\n", StringUtil.firstToLowerCase(this.invoker.getParentClassName()), info.getColumnName(), info.getPropertyName()));
            }
        }));
        sb.append("        ").append("</collection>");
        return sb.toString();
    }

    public String insertProperties() {
        StringBuilder sb = new StringBuilder();
        this.invoker.getTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            sb.append(index == 0 ? "" : "            ");
            sb.append(String.format("`%s`,\n", info.getColumnName()));
        }));
        return sb.toString().substring(0, sb.toString().length() - 2);
    }

    public String insertValues() {
        StringBuilder sb = new StringBuilder();
        this.invoker.getTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            sb.append(index == 0 ? "" : "            ");
            if (StringUtil.isEmpty(this.invoker.getRelationalTableName()) && !StringUtil.isEmpty(this.invoker.getForeignKey())) {
                if (info.getColumnName().equals(this.invoker.getForeignKey())) {
                    sb.append(String.format("#{%s.%s},\n", StringUtil.firstToLowerCase(this.invoker.getParentClassName()), this.getPrimaryKeyColumnInfo(this.invoker.getParentTableInfos()).getPropertyName()));
                } else {
                    sb.append(String.format("#{%s},\n", info.getPropertyName()));
                }
            } else {
                sb.append(String.format("#{%s},\n", info.getPropertyName()));
            }
        }));
        return sb.toString().substring(0, sb.toString().length() - 2);
    }

    public String insertBatchValues() {
        StringBuilder sb = new StringBuilder();
        this.invoker.getTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            sb.append(index == 0 ? "" : "            ");
            if (StringUtil.isEmpty(this.invoker.getRelationalTableName()) && !StringUtil.isEmpty(this.invoker.getForeignKey())) {
                if (info.getColumnName().equals(this.invoker.getForeignKey())) {
                    sb.append(String.format("#{%s.%s.%s},\n", StringUtil.firstToLowerCase(this.invoker.getClassName()), StringUtil.firstToLowerCase(this.invoker.getParentClassName()), this.getPrimaryKeyColumnInfo(this.invoker.getParentTableInfos()).getPropertyName()));
                } else {
                    sb.append(String.format("#{%s.%s},\n", StringUtil.firstToLowerCase(this.invoker.getClassName()), info.getPropertyName()));
                }
            } else {
                sb.append(String.format("#{%s.%s},\n", StringUtil.firstToLowerCase(this.invoker.getClassName()), info.getPropertyName()));
            }
        }));
        return sb.toString().substring(0, sb.toString().length() - 2);
    }

    public String updateProperties() {
        StringBuilder sb = new StringBuilder();
        this.invoker.getTableInfos().forEach(ForEachUtil.withIndex((info, index) -> {
            sb.append(index == 0 ? "" : "        ");
            if (StringUtil.isEmpty(this.invoker.getRelationalTableName()) && !StringUtil.isEmpty(this.invoker.getForeignKey())) {
                if (info.getColumnName().equals(this.invoker.getForeignKey())) {
                    sb.append(String.format("`%s` = #{%s.%s},\n", info.getColumnName(), StringUtil.firstToLowerCase(this.invoker.getParentClassName()), this.getPrimaryKeyColumnInfo(this.invoker.getParentTableInfos()).getPropertyName()));
                } else {
                    sb.append(String.format("`%s` = #{%s},\n", info.getColumnName(), info.getPropertyName()));
                }
            } else {
                sb.append(String.format("`%s` = #{%s},\n", info.getColumnName(), info.getPropertyName()));
            }
        }));
        return sb.toString().substring(0, sb.toString().length() - 2);
    }

    public String joins() {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(this.invoker.getRelationalTableName())) {
            sb.append(String.format("LEFT JOIN `%s` ON `%s`.`%s` = `%s`.`%s`", this.invoker.getRelationalTableName(), this.invoker.getRelationalTableName(), this.invoker.getForeignKey(), this.invoker.getTableName(), this.getPrimaryKeyColumnInfo(this.invoker.getTableInfos()).getColumnName()));
            sb.append("\n").append("        ");
            sb.append(String.format("LEFT JOIN `%s` ON `%s`.`%s` = `%s`.`%s`", this.invoker.getParentTableName(), this.invoker.getParentTableName(), this.getPrimaryKeyColumnInfo(this.invoker.getParentTableInfos()).getColumnName(), this.invoker.getRelationalTableName(), this.invoker.getParentForeignKey()));
        } else if (!StringUtil.isEmpty(this.invoker.getParentForeignKey())) {
            sb.append(String.format("LEFT JOIN `%s` ON `%s`.`%s` = `%s`.`%s`", this.invoker.getParentTableName(), this.invoker.getParentTableName(), this.invoker.getParentForeignKey(), this.invoker.getTableName(), this.getPrimaryKeyColumnInfo(this.invoker.getTableInfos()).getColumnName()));
        } else if (!StringUtil.isEmpty(this.invoker.getForeignKey())) {
            sb.append(String.format("LEFT JOIN `%s` ON `%s`.%s = `%s`.`%s`", this.invoker.getParentTableName(), this.invoker.getParentTableName(), this.getPrimaryKeyColumnInfo(this.invoker.getParentTableInfos()).getColumnName(), this.invoker.getTableName(), this.invoker.getForeignKey()));
        }
        return sb.toString();
    }
}

