/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.task;

import com.greedystar.generator.invoker.base.AbstractInvoker;
import com.greedystar.generator.task.base.AbstractTask;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.FileUtil;
import com.greedystar.generator.utils.StringUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;

public class ServiceTask
extends AbstractTask {
    public ServiceTask(AbstractInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public void run() throws IOException, TemplateException {
        String fileName;
        HashMap<String, Object> serviceData = new HashMap<String, Object>();
        serviceData.put("Configuration", ConfigUtil.getConfiguration());
        serviceData.put("ClassName", ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getClassName()));
        serviceData.put("EntityName", StringUtil.firstToLowerCase(ConfigUtil.getConfiguration().getName().getEntity().replace("$s", this.invoker.getClassName())));
        serviceData.put("DaoClassName", ConfigUtil.getConfiguration().getName().getDao().replace("$s", this.invoker.getClassName()));
        serviceData.put("DaoEntityName", StringUtil.firstToLowerCase(ConfigUtil.getConfiguration().getName().getDao().replace("$s", this.invoker.getClassName())));
        String filePath = FileUtil.getSourcePath() + StringUtil.package2Path(ConfigUtil.getConfiguration().getPackageName()) + StringUtil.package2Path(ConfigUtil.getConfiguration().getPath().getService());
        String serviceClassName = ConfigUtil.getConfiguration().getName().getService().replace("$s", this.invoker.getClassName());
        if (StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getInterf())) {
            serviceData.put("ServiceClassName", serviceClassName);
            serviceData.put("Implements", "");
            serviceData.put("InterfaceImport", "");
            serviceData.put("Override", "");
            fileName = ConfigUtil.getConfiguration().getName().getService().replace("$s", this.invoker.getClassName()) + ".java";
        } else {
            serviceClassName = serviceClassName.contains("Impl") ? serviceClassName : serviceClassName + "Impl";
            serviceData.put("ServiceClassName", serviceClassName);
            serviceData.put("Implements", "implements " + ConfigUtil.getConfiguration().getName().getInterf().replace("$s", this.invoker.getClassName()));
            serviceData.put("InterfaceImport", "import " + ConfigUtil.getConfiguration().getPackageName() + "." + ConfigUtil.getConfiguration().getPath().getInterf() + "." + ConfigUtil.getConfiguration().getName().getInterf().replace("$s", this.invoker.getClassName()) + ";");
            serviceData.put("Override", "\n    @Override");
            fileName = serviceClassName + ".java";
        }
        FileUtil.generateToJava(2, serviceData, filePath, fileName);
    }
}

