/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.utils;

import com.greedystar.generator.entity.Configuration;
import com.greedystar.generator.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.Yaml;

public class ConfigUtil {
    private static volatile Configuration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getConfiguration() {
        if (null != configuration) return configuration;
        Class<ConfigUtil> clazz = ConfigUtil.class;
        synchronized (ConfigUtil.class) {
            if (null != configuration) return configuration;
            ConfigUtil.readConfigurationFromFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configuration;
        }
    }

    public static void setConfiguration(Configuration configuration) {
        ConfigUtil.configuration = configuration;
        ConfigUtil.checkConfiguration();
    }

    private static void readConfigurationFromFile() {
        try {
            URL url = ConfigUtil.class.getClassLoader().getResource("generator.yaml");
            if (null == url || url.getPath().contains("jar")) {
                System.err.println("Can not find file named 'generator.yaml' under resources path, please make sure that you have defined that file.");
                System.exit(0);
            } else {
                String configStr = StringUtil.line2Camel(IOUtils.toString((InputStream)((InputStream)url.getContent())));
                InputStream inputStream = IOUtils.toInputStream((String)configStr, (String)StandardCharsets.UTF_8.name());
                Yaml yaml = new Yaml();
                ConfigUtil.setConfiguration((Configuration)yaml.loadAs(inputStream, Configuration.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static void checkConfiguration() {
        try {
            if (null == configuration.getName()) {
                Configuration.Name nameConfig = new Configuration.Name();
                if (configuration.isJpaEnable()) {
                    nameConfig.setDao("$sRepository");
                } else if (configuration.isMybatisPlusEnable()) {
                    nameConfig.setDao("$sMapper");
                }
                configuration.setName(nameConfig);
            }
            if (null == configuration.getDb()) {
                throw new Exception("Can not find configuration attribute named 'db', please make sure that you have configured that attribute.");
            }
            if (null == configuration.getPath()) {
                throw new Exception("Can not find configuration attribute named 'path', please make sure that you have configured that attribute.");
            }
            if (StringUtil.isEmpty(configuration.getDb().getUrl()) || StringUtil.isEmpty(configuration.getDb().getUsername())) {
                throw new Exception("Please configure the correct db connection parameters, i.e. url, username and password.");
            }
            if (StringUtil.isEmpty(configuration.getPackageName())) {
                throw new Exception("Please configure the correct attribute named 'package-name' or 'packageName'.");
            }
            if (configuration.isMybatisPlusEnable() && configuration.isJpaEnable()) {
                throw new Exception("Can not enable JPA mode and MyBatis-Plus mode at the same time.");
            }
            if (configuration.isMybatisPlusEnable() || configuration.isJpaEnable()) {
                configuration.getPath().setMapper(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

