/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.utils;

import com.greedystar.generator.convertor.DefaultConvertor;
import com.greedystar.generator.convertor.TypeConvertor;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.StringUtil;
import java.sql.JDBCType;

public class ConvertorUtil {
    private static volatile TypeConvertor convertor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String parseTypeFormSqlType(JDBCType type) {
        if (convertor != null) return convertor.convertType(type);
        Class<ConvertorUtil> clazz = ConvertorUtil.class;
        synchronized (ConvertorUtil.class) {
            if (convertor != null) return convertor.convertType(type);
            convertor = ConvertorUtil.newInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return convertor.convertType(type);
        }
    }

    private static TypeConvertor newInstance() {
        TypeConvertor convertor;
        String convertorClass = ConfigUtil.getConfiguration().getConvertor();
        if (StringUtil.isEmpty(convertorClass)) {
            convertor = new DefaultConvertor();
        } else {
            try {
                Class<?> clazz = Class.forName(ConfigUtil.getConfiguration().getConvertor());
                convertor = (TypeConvertor)clazz.newInstance();
            }
            catch (Exception e) {
                System.err.println(String.format("Can not find %s, DefaultConvertor will be used.", convertorClass));
                convertor = new DefaultConvertor();
            }
        }
        return convertor;
    }
}

