/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.utils;

import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.FreemarkerConfigUtil;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;

public class FileUtil {
    public static void generateToJava(int type, Object data, String filePath, String fileName) throws IOException, TemplateException {
        String path = filePath + fileName;
        File file = new File(path);
        if (file.exists() && !ConfigUtil.getConfiguration().isFileOverride()) {
            path = path + ".generated";
            System.err.printf("%s already exit. Generating %s \n", fileName, path);
        } else {
            System.out.printf("Generating %s \n", path);
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Template tpl = FileUtil.getTemplate(type);
        StringWriter writer = new StringWriter();
        tpl.process(data, (Writer)writer);
        writer.flush();
        FileOutputStream fos = new FileOutputStream(path);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw, 1024);
        tpl.process(data, (Writer)bw);
        writer.close();
        bw.close();
    }

    private static Template getTemplate(int type) throws IOException {
        switch (type) {
            case 0: {
                return FreemarkerConfigUtil.getInstance().getTemplate("Entity.ftl");
            }
            case 1: {
                return FreemarkerConfigUtil.getInstance().getTemplate("Dao.ftl");
            }
            case 2: {
                return FreemarkerConfigUtil.getInstance().getTemplate("Service.ftl");
            }
            case 3: {
                return FreemarkerConfigUtil.getInstance().getTemplate("Controller.ftl");
            }
            case 4: {
                return FreemarkerConfigUtil.getInstance().getTemplate("Mapper.ftl");
            }
            case 5: {
                return FreemarkerConfigUtil.getInstance().getTemplate("Interface.ftl");
            }
        }
        return null;
    }

    private static String getBasicProjectPath() {
        StringBuilder sb = new StringBuilder();
        String path = FileUtil.class.getClassLoader().getResource("").getPath().replace("/", File.separator);
        if (path.contains("target")) {
            sb.append(path, 0, path.indexOf("target"));
        } else if (path.contains("build")) {
            sb.append(path, 0, path.indexOf("build"));
        }
        sb.append("src").append(File.separator).append("main").append(File.separator);
        return sb.toString();
    }

    public static String getSourcePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(FileUtil.getBasicProjectPath()).append("java").append(File.separator);
        return sb.toString();
    }

    public static String getResourcePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(FileUtil.getBasicProjectPath()).append("resources").append(File.separator);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.getResourcePath());
        System.out.println(FileUtil.getSourcePath());
    }
}

