/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.utils;

import com.greedystar.generator.entity.Mode;
import com.greedystar.generator.invoker.base.AbstractInvoker;
import com.greedystar.generator.task.ControllerTask;
import com.greedystar.generator.task.DaoTask;
import com.greedystar.generator.task.EntityTask;
import com.greedystar.generator.task.InterfaceTask;
import com.greedystar.generator.task.MapperTask;
import com.greedystar.generator.task.ServiceTask;
import com.greedystar.generator.task.base.AbstractTask;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.StringUtil;
import java.util.LinkedList;

public class TaskQueue {
    private LinkedList<AbstractTask> taskQueue = new LinkedList();

    private void initCommonTasks(AbstractInvoker invoker) {
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getController())) {
            this.taskQueue.add(new ControllerTask(invoker));
        }
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getService())) {
            this.taskQueue.add(new ServiceTask(invoker));
        }
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getInterf())) {
            this.taskQueue.add(new InterfaceTask(invoker));
        }
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getDao())) {
            this.taskQueue.add(new DaoTask(invoker));
        }
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getMapper())) {
            this.taskQueue.add(new MapperTask(invoker));
        }
    }

    public void initSingleTasks(AbstractInvoker invoker) {
        this.initCommonTasks(invoker);
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getEntity())) {
            this.taskQueue.add(new EntityTask(Mode.ENTITY_MAIN, invoker));
        }
    }

    public void initMany2OneTasks(AbstractInvoker invoker) {
        this.initCommonTasks(invoker);
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getEntity())) {
            this.taskQueue.add(new EntityTask(Mode.ENTITY_MAIN, invoker));
            this.taskQueue.add(new EntityTask(Mode.ENTITY_PARENT, invoker));
        }
    }

    public void initOne2ManyTasks(AbstractInvoker invoker) {
        this.initCommonTasks(invoker);
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getEntity())) {
            this.taskQueue.add(new EntityTask(Mode.ENTITY_MAIN, invoker));
            this.taskQueue.add(new EntityTask(Mode.ENTITY_PARENT, invoker));
        }
    }

    public void initMany2ManyTasks(AbstractInvoker invoker) {
        this.initCommonTasks(invoker);
        if (!StringUtil.isEmpty(ConfigUtil.getConfiguration().getPath().getEntity())) {
            this.taskQueue.add(new EntityTask(Mode.ENTITY_MAIN, invoker));
            this.taskQueue.add(new EntityTask(Mode.ENTITY_PARENT, invoker));
        }
    }

    public boolean isEmpty() {
        return this.taskQueue.isEmpty();
    }

    public AbstractTask poll() {
        return this.taskQueue.poll();
    }
}

