/*
 * Decompiled with CFR 0.152.
 */
package com.greenbird.configuration.jmx;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.greenbird.configuration.context.SpringContextLoader;
import com.greenbird.configuration.properties.ConfigurationPropertyPlaceholderConfigurer;
import com.greenbird.configuration.util.ResourceFinder;
import com.greenbird.configuration.util.SpringContextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Service;

@Service
@ManagedResource(value="greenbird.configuration:name=greenbirdConfiguration,type=GreenbirdConfiguration")
public class ConfigurationMBean
implements ApplicationContextAware {
    private ResourceFinder resourceFinder = new ResourceFinder();
    private Environment environment;
    private ApplicationContext applicationContext;
    private ConfigurationPropertyPlaceholderConfigurer placeholderConfigurer = null;

    @ManagedAttribute
    public String getActiveSpringProfiles() {
        return this.getProfilesString(this.environment.getActiveProfiles());
    }

    @ManagedAttribute
    public String getDefaultSpringProfiles() {
        return this.getProfilesString(this.environment.getDefaultProfiles());
    }

    @ManagedAttribute
    public List<String> getLoadedConfigurationFiles() {
        List result = this.placeholderConfigurer != null ? Lists.transform(this.placeholderConfigurer.getLoadedPropertyFiles(), (Function)new Function<Resource, String>(){

            public String apply(Resource resource) {
                return resource.toString();
            }
        }) : Collections.emptyList();
        return result;
    }

    @ManagedAttribute
    public String getPropertiesReport() {
        String result = this.placeholderConfigurer != null ? this.placeholderConfigurer.createPropertyReport() : "";
        return result;
    }

    @ManagedAttribute
    public List<String> getLoadedSpringDefinitionFiles() {
        List result = SpringContextUtils.getBeanIfAvailable(this.applicationContext, SpringContextLoader.class) != null ? Lists.transform(Arrays.asList(this.resourceFinder.findContextDefinitions()), (Function)new Function<Resource, String>(){

            public String apply(Resource resource) {
                return resource.toString();
            }
        }) : Collections.emptyList();
        return result;
    }

    @ManagedAttribute
    public List<String> getBeansInContext() {
        ArrayList<String> beans = new ArrayList<String>();
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            Object bean;
            try {
                bean = this.applicationContext.getBean(beanName);
            }
            catch (BeanIsAbstractException e) {
                continue;
            }
            String beanClass = bean.getClass().getName();
            if (beanClass.startsWith("org.springframework")) continue;
            beans.add(String.format("%s (%s)", beanName, beanClass));
        }
        return Ordering.natural().sortedCopy(beans);
    }

    private String getProfilesString(String[] profiles) {
        String profilesString = profiles.length > 0 ? Joiner.on((String)", ").join((Object[])profiles) : "<none>";
        return profilesString;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.placeholderConfigurer = SpringContextUtils.getBeanIfAvailable(applicationContext, ConfigurationPropertyPlaceholderConfigurer.class);
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceFinder(ResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
    }
}

