/*
 * Decompiled with CFR 0.152.
 */
package com.greenbird.configuration.properties;

import com.greenbird.GreenbirdException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.constretto.ConstrettoConfiguration;
import org.constretto.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationDirectoryLoader {
    public static final String CONFIG_DIR_PROPERTY = "greenbird.config.dir";
    public static final String NIX_FRIENDLY_CONFIG_DIR_PROPERTY = "greenbird.config.dir".replace(".", "_");
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    ConfigurationDirectoryLoader() {
    }

    Set<File> getConfigurationDirectories(ConstrettoConfiguration classpathConfiguration) {
        LinkedHashSet<String> uniquePaths = new LinkedHashSet<String>();
        LinkedHashSet<File> uniqueDirectories = new LinkedHashSet<File>();
        this.getDirectoriesFromConfiguration(classpathConfiguration, uniquePaths, uniqueDirectories);
        this.getDirectoriesFromSystemProperties(uniquePaths, uniqueDirectories);
        this.getDirectoriesFromEnvironment(uniquePaths, uniqueDirectories);
        return uniqueDirectories;
    }

    private void getDirectoriesFromConfiguration(ConstrettoConfiguration configuration, Set<String> uniquePaths, Set<File> uniqueDirectories) {
        for (Property property : configuration) {
            this.processProperty(property.getKey(), property.getValue(), uniquePaths, uniqueDirectories);
        }
    }

    private void getDirectoriesFromSystemProperties(Set<String> uniquePaths, Set<File> uniqueDirectories) {
        Properties properties = System.getProperties();
        for (String name : properties.stringPropertyNames()) {
            this.processProperty(name, properties.getProperty(name), uniquePaths, uniqueDirectories);
        }
    }

    private void getDirectoriesFromEnvironment(Set<String> uniquePaths, Set<File> uniqueDirectories) {
        for (Map.Entry<String, String> envEntry : System.getenv().entrySet()) {
            this.processProperty(envEntry.getKey(), envEntry.getValue(), uniquePaths, uniqueDirectories);
        }
    }

    private void processProperty(String name, String value, Set<String> uniquePaths, Set<File> uniqueDirectories) {
        if (this.isConfigurationDirectoryProperty(name)) {
            File configDir = new File(value);
            boolean isUsable = this.isUsableDirectory(configDir, name, value);
            try {
                if (isUsable && uniquePaths.add(configDir.getCanonicalPath())) {
                    uniqueDirectories.add(configDir);
                }
            }
            catch (IOException e) {
                throw new GreenbirdException((Throwable)e);
            }
        }
    }

    private boolean isConfigurationDirectoryProperty(String name) {
        return name.endsWith(CONFIG_DIR_PROPERTY) || name.equals(NIX_FRIENDLY_CONFIG_DIR_PROPERTY);
    }

    private boolean isUsableDirectory(File configDir, String propertyName, String propertyValue) {
        boolean usable = false;
        if (!configDir.exists()) {
            this.logger.warn(String.format("Configuration directory %s defined in %s does not exists.", propertyValue, propertyName));
        } else if (!configDir.isDirectory()) {
            this.logger.warn(String.format("Configuration directory %s defined in %s is not a directory.", propertyValue, propertyName));
        } else if (!configDir.canRead()) {
            this.logger.warn(String.format("Configuration directory %s defined in %s is not readable.", propertyValue, propertyName));
        } else {
            usable = true;
        }
        return usable;
    }
}

