/*
 * Decompiled with CFR 0.152.
 */
package com.greenbird.configuration.properties;

import com.google.common.collect.Iterators;
import com.greenbird.configuration.properties.ConfigurationDirectoryLoader;
import com.greenbird.configuration.properties.GreenbirdConfigurationContextResolver;
import com.greenbird.configuration.properties.PropertyReportCreator;
import com.greenbird.configuration.util.ResourceFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.constretto.ConstrettoBuilder;
import org.constretto.ConstrettoConfiguration;
import org.constretto.Property;
import org.constretto.exception.ConstrettoExpressionException;
import org.constretto.resolver.ConfigurationContextResolver;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationPropertyPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer {
    private static final String PRESET_PROFILE = "preset";
    public static final String GREENBIRD_CONFIG_UUID_KEY = "GREENBIRD_CONFIG_UUID";
    private static final Pattern GREENBIRD_CONFIG_UUID_PATTERN = Pattern.compile("GREENBIRD_CONFIG_UUID");
    private ResourceFinder resourceFinder = new ResourceFinder();
    private List<Resource> loadedPropertyFiles = new ArrayList<Resource>();
    private ConstrettoConfiguration classpathConfiguration;
    private ConstrettoConfiguration fileSystemConfiguration;

    public void setEnvironment(Environment environment) {
        this.loadClasspathProperties(environment);
        this.loadFileSystemProperties(environment);
        ((ConfigurableEnvironment)environment).getPropertySources().addLast((PropertySource)new PropertySource<Object>("gbConfSource"){

            public Object getProperty(String name) {
                return ConfigurationPropertyPlaceholderConfigurer.this.getProperty(name);
            }
        });
        super.setEnvironment(environment);
    }

    private void loadClasspathProperties(Environment environment) {
        ConstrettoBuilder.PropertiesStoreBuilder propertiesBuilder = new ConstrettoBuilder((ConfigurationContextResolver)new GreenbirdConfigurationContextResolver(environment)).createPropertiesStore();
        this.addClasspathPropertyResources(propertiesBuilder, PRESET_PROFILE);
        this.addClasspathPropertyResources(propertiesBuilder, environment.getDefaultProfiles());
        this.addClasspathPropertyResources(propertiesBuilder, environment.getActiveProfiles());
        this.classpathConfiguration = propertiesBuilder.done().getConfiguration();
    }

    private void loadFileSystemProperties(Environment environment) {
        ConstrettoBuilder.PropertiesStoreBuilder propertiesBuilder = new ConstrettoBuilder((ConfigurationContextResolver)new GreenbirdConfigurationContextResolver(environment)).createPropertiesStore();
        Set<File> configurationDirectories = new ConfigurationDirectoryLoader().getConfigurationDirectories(this.classpathConfiguration);
        this.addFileSystemPropertyResources(propertiesBuilder, configurationDirectories, PRESET_PROFILE);
        this.addFileSystemPropertyResources(propertiesBuilder, configurationDirectories, environment.getDefaultProfiles());
        this.addFileSystemPropertyResources(propertiesBuilder, configurationDirectories, environment.getActiveProfiles());
        this.fileSystemConfiguration = propertiesBuilder.done().getConfiguration();
    }

    private void addClasspathPropertyResources(ConstrettoBuilder.PropertiesStoreBuilder propertiesBuilder, String ... profiles) {
        for (String profile : profiles) {
            Resource[] resources = this.resourceFinder.findClasspathConfigurationFilesForProfile(profile);
            this.addResources(propertiesBuilder, resources);
        }
    }

    private void addFileSystemPropertyResources(ConstrettoBuilder.PropertiesStoreBuilder propertiesBuilder, Set<File> configurationDirectories, String ... profiles) {
        for (File configurationDirectory : configurationDirectories) {
            for (String profile : profiles) {
                Resource[] resources = this.resourceFinder.findFileSystemConfigurationFilesForProfile(configurationDirectory, profile);
                this.addResources(propertiesBuilder, resources);
            }
        }
    }

    private void addResources(ConstrettoBuilder.PropertiesStoreBuilder propertiesBuilder, Resource[] resources) {
        for (Resource propertyResource : resources) {
            this.loadedPropertyFiles.add(propertyResource);
            propertiesBuilder.addResource(propertyResource);
        }
    }

    private String getProperty(String name) {
        String value = this.getValue(name, this.fileSystemConfiguration);
        if (value == null) {
            value = this.getValue(name, this.classpathConfiguration);
        }
        if (value != null && value.contains(GREENBIRD_CONFIG_UUID_KEY)) {
            value = this.buildRandomPropertyValue(value);
        }
        return value;
    }

    private String getValue(String name, ConstrettoConfiguration configuration) {
        String value = null;
        try {
            value = (String)configuration.evaluateTo(String.class, name);
        }
        catch (ConstrettoExpressionException e) {
            // empty catch block
        }
        return value;
    }

    private String buildRandomPropertyValue(String value) {
        Matcher uuidMatcher = GREENBIRD_CONFIG_UUID_PATTERN.matcher(value);
        StringBuffer result = new StringBuffer();
        while (uuidMatcher.find()) {
            uuidMatcher.appendReplacement(result, UUID.randomUUID().toString());
        }
        uuidMatcher.appendTail(result);
        return result.toString();
    }

    public String createPropertyReport() {
        String maskPattern = this.getProperty("greenbird.config.mask.pattern");
        Set<Property> uniqueProperties = this.getPropertySet();
        return new PropertyReportCreator(maskPattern).createPropertyReport(uniqueProperties);
    }

    private Set<Property> getPropertySet() {
        HashSet<String> fileSystemPropertyNames = new HashSet<String>();
        HashSet<Property> uniqueProperties = new HashSet<Property>();
        Iterators.addAll(uniqueProperties, (Iterator)this.fileSystemConfiguration.iterator());
        for (Property property : this.fileSystemConfiguration) {
            fileSystemPropertyNames.add(property.getKey());
        }
        for (Property property : this.classpathConfiguration) {
            if (fileSystemPropertyNames.contains(property.getKey())) continue;
            uniqueProperties.add(property);
        }
        return uniqueProperties;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (Property property : this.getPropertySet()) {
            properties.setProperty(property.getKey(), property.getValue());
        }
        return properties;
    }

    public List<Resource> getLoadedPropertyFiles() {
        return this.loadedPropertyFiles;
    }
}

