/*
 * Decompiled with CFR 0.152.
 */
package com.greenbird.configuration.properties;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.constretto.Property;
import org.springframework.util.StringUtils;

class PropertyReportCreator {
    public static final String MASK_PATTERN_PROPERTY = "greenbird.config.mask.pattern";
    private static final Pattern DEFAULT_MASKING_PATTERN = Pattern.compile(".*(\\.pw|password|passwd|pwd).*", 2);
    private static final String LS = System.getProperty("line.separator");
    private Pattern additionalMaskingPattern = null;

    PropertyReportCreator(String maskPattern) {
        if (StringUtils.hasText((String)maskPattern)) {
            this.additionalMaskingPattern = Pattern.compile(maskPattern, 2);
        }
    }

    String createPropertyReport(Iterable<Property> configuration) {
        int maxNameLength = this.getMaxPropertyLength(configuration);
        List<Property> properties = this.sortProperties(configuration);
        StringBuilder reportBuilder = new StringBuilder();
        for (Property property : properties) {
            reportBuilder.append(String.format("%-" + maxNameLength + "s = %s", property.getKey(), this.formatValue(property))).append(LS);
        }
        return reportBuilder.toString();
    }

    private int getMaxPropertyLength(Iterable<Property> configuration) {
        int maxNameLength = 0;
        for (Property property : configuration) {
            maxNameLength = Math.max(property.getKey().length(), maxNameLength);
        }
        return maxNameLength;
    }

    private List<Property> sortProperties(Iterable<Property> properties) {
        Comparator<Property> propertyComparator = new Comparator<Property>(){

            @Override
            public int compare(Property property1, Property property2) {
                return property1.getKey().compareTo(property2.getKey());
            }
        };
        return Ordering.from((Comparator)propertyComparator).sortedCopy(properties);
    }

    private String formatValue(Property property) {
        String key = property.getKey();
        String value = property.getValue();
        if (this.valueShouldBeMasked(key)) {
            value = "*****";
        }
        return value;
    }

    private boolean valueShouldBeMasked(String key) {
        return DEFAULT_MASKING_PATTERN.matcher(key).matches() || this.additionalMaskingPattern != null && this.additionalMaskingPattern.matcher(key).matches();
    }
}

