/*
 * Decompiled with CFR 0.152.
 */
package com.greenbird.configuration.util;

import com.greenbird.configuration.ConfigurationException;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

public class ResourceFinder {
    public static final String CONFIG_ROOT_PATH = "classpath*:/gb-conf/**/";
    public static final String CONTEXT_PATTERN = "classpath*:/gb-conf/**/*-context.xml";
    private static final String CONFIGURATION_FILE_TEMPLATE = "*-%s.properties";
    private static final String CONFIGURATION_FILE_PATTERN = "classpath*:/gb-conf/**/*-%s.properties";
    private final ResourcePatternResolver resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)new DefaultResourceLoader(Thread.currentThread().getContextClassLoader()));

    public Resource[] findContextDefinitions() {
        return this.findResources(CONTEXT_PATTERN);
    }

    public Resource[] findClasspathConfigurationFilesForProfile(String profileName) {
        return this.findResources(String.format(CONFIGURATION_FILE_PATTERN, profileName));
    }

    public Resource[] findFileSystemConfigurationFilesForProfile(File configDir, String profileName) {
        StringBuilder filePatternBuilder = new StringBuilder(configDir.toURI().toString());
        if (!filePatternBuilder.toString().endsWith("/")) {
            filePatternBuilder.append("/");
        }
        filePatternBuilder.append("**/").append(String.format(CONFIGURATION_FILE_TEMPLATE, profileName));
        return this.findResources(filePatternBuilder.toString());
    }

    private Resource[] findResources(String locationPattern) {
        Resource[] resources;
        try {
            resources = this.resourcePatternResolver.getResources(locationPattern);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to search for Greenbird resources.", e);
        }
        return resources;
    }
}

