/*
 * Decompiled with CFR 0.152.
 */
package com.greenbird.net;

import com.greenbird.GreenbirdException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.validator.routines.InetAddressValidator;

public class LocalIpSelector {
    private String preferredInterface;

    public String getIp() {
        String ip = null;
        if (this.preferredInterface != null) {
            ip = this.getIpForInterface(this.preferredInterface);
        }
        if (ip == null) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new GreenbirdException(e);
            }
        }
        return ip;
    }

    public void setPreferredInterface(String interfaceName) {
        this.preferredInterface = interfaceName;
    }

    private String getIpForInterface(String interfaceName) {
        Enumeration<NetworkInterface> networkInterfaces;
        String ip = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new GreenbirdException(e);
        }
        while (networkInterfaces.hasMoreElements() && ip == null) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!networkInterface.getName().equals(interfaceName)) continue;
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements() && ip == null) {
                String address = addresses.nextElement().getHostAddress();
                if (!InetAddressValidator.getInstance().isValidInet4Address(address)) continue;
                ip = address;
            }
        }
        return ip;
    }
}

