package com.greenbird.net;

import com.greenbird.GreenbirdException;
import org.apache.commons.validator.routines.InetAddressValidator;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class LocalIpSelector {
    private String preferredInterface;

    public String getIp() {
        String ip = null;
        if (preferredInterface != null) {
            ip = getIpForInterface(preferredInterface);
        }

        if (ip == null) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            } catch (UnknownHostException e) {
                throw new GreenbirdException(e);
            }
        }
        return ip;
    }

    public void setPreferredInterface(String interfaceName) {
        preferredInterface = interfaceName;
    }

    private String getIpForInterface(String interfaceName) {
        String ip = null;
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        } catch (SocketException e) {
            throw new GreenbirdException(e);
        }
        while (networkInterfaces.hasMoreElements() && ip == null) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterface.getName().equals(interfaceName)) {
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements() && ip == null) {
                    String address = addresses.nextElement().getHostAddress();
                    if (InetAddressValidator.getInstance().isValidInet4Address(address)) {
                        ip = address;
                    }
                }
            }

        }
        return ip;
    }
}
