package com.greenbird.text;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Collection;

public class RecursiveToStringStyle extends ToStringStyle {
    public RecursiveToStringStyle() {
        setUseShortClassName(true);
        setUseIdentityHashCode(false);
    }

    @Override
    protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        if (value.getClass().getName().startsWith("java.lang.")) {
            buffer.append(value);
        } else {
            buffer.append(ReflectionToStringBuilder.toString(value, this));
        }
    }

    @Override
    protected void appendDetail(StringBuffer buffer, String fieldName, Collection collection) {
        buffer.append(ReflectionToStringBuilder.toString(collection.toArray(), this, true, true));
    }
}
