package com.greenbird.ws;

import javax.xml.ws.BindingProvider;

public class JaxWsUtil {
    private JaxWsUtil() {
        // NOP
    }

    public static void setEndpointAddress(Object servicePort, String endpointAddress) {
        if (!(servicePort instanceof BindingProvider)) {
            throw new IllegalArgumentException(String.format("Service port must be an instance of %s but was %s.",
                    BindingProvider.class.getName(), servicePort.getClass().getName()));
        }
        BindingProvider bindingProvider = (BindingProvider) servicePort;
        bindingProvider.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endpointAddress);
    }
}
