/*
 * Decompiled with CFR 0.152.
 */
package com.greenbird.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathRoot {
    private XPath xpathParser = XPathFactory.newInstance().newXPath();
    private Node root;
    private NamespaceContext namespaceContext;

    private XPathRoot(InputSource inputSource) {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            this.root = builder.parse(inputSource);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialise xml document.", e);
        }
    }

    private XPathRoot(Node node) {
        this.root = node;
    }

    public static XPathRoot forNode(Node node) {
        return new XPathRoot(node);
    }

    public static XPathRoot forSource(InputSource xmlSource) {
        return new XPathRoot(xmlSource);
    }

    public static XPathRoot forString(String xmlString) {
        return XPathRoot.forSource(new InputSource(new StringReader(xmlString)));
    }

    public static XPathRoot forResource(String xmlPath) {
        return XPathRoot.forSource(new InputSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlPath)));
    }

    public XPathRoot withNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
        if (namespaceContext != null) {
            this.xpathParser.setNamespaceContext(namespaceContext);
        }
        return this;
    }

    public List<Node> nodes(String xPath) {
        return this.nodes(xPath, this.root);
    }

    public List<Node> nodes(String xPath, Object context) {
        NodeList nodeList = (NodeList)this.evaluate(xPath, context, XPathConstants.NODESET);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    public Node node(String xPath) {
        return this.node(xPath, this.root);
    }

    public Node node(String xPath, Object context) {
        return (Node)this.evaluate(xPath, context, XPathConstants.NODE);
    }

    public String value(String xPath) {
        return (String)this.evaluate(xPath, this.root, XPathConstants.STRING);
    }

    public String value(String xPath, Object context) {
        return (String)this.evaluate(xPath, context, XPathConstants.STRING);
    }

    public XPathRoot rootFrom(String xPath) {
        return this.rootFrom(this.node(xPath));
    }

    public XPathRoot rootFrom(Node rootNode) {
        return XPathRoot.forNode(rootNode).withNamespaceContext(this.namespaceContext);
    }

    private <T> T evaluate(String xPath, Object context, QName type) {
        try {
            return (T)this.xpathParser.evaluate(this.removeAbsoluteRootPathElement(xPath), context, type);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(String.format("Failed to parse expression '%s' for context %s.", xPath, context), e);
        }
    }

    private String removeAbsoluteRootPathElement(String xPath) {
        String trimmedXpath = xPath;
        if (xPath.startsWith("/") && xPath.charAt(1) != '/') {
            trimmedXpath = xPath.substring(1);
        }
        return trimmedXpath;
    }
}

