/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.aggregate.maven;

import com.groupcdg.pitest.aggregate.AbstractAggregationMojo;
import com.groupcdg.pitest.aggregate.AnnotationAggregator;
import com.groupcdg.pitest.aggregate.SummaryAggregator;
import com.groupcdg.pitest.github.GithubPayload;
import com.groupcdg.pitest.util.CoverageIgnore;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.VERIFY, aggregator=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE)
public class AggregateFilesMojo
extends AbstractAggregationMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="githubEventPath", defaultValue="${env.GITHUB_EVENT_PATH}")
    private String githubEventPath;
    private final AnnotationAggregator annotationAggregator;
    private final SummaryAggregator summaryAggregator;

    public AggregateFilesMojo() {
        this(FileSystems.getDefault(), new SummaryAggregator(), new AnnotationAggregator());
    }

    public AggregateFilesMojo(FileSystem fs, SummaryAggregator summaryAggregator, AnnotationAggregator annotationAggregator) {
        super(fs);
        this.annotationAggregator = annotationAggregator;
        this.summaryAggregator = summaryAggregator;
    }

    public void execute() throws MojoExecutionException {
        Path outDir = this.fs.getPath(this.project().getBuild().getDirectory(), "pit-reports-ci");
        try {
            Files.createDirectories(outDir, new FileAttribute[0]);
            this.storePRDetailsIfPresent(outDir);
            this.aggregateAnnotationJson(outDir);
            this.aggregateSimplifiedJson(outDir);
            if (this.summaryConfig().isEnabled()) {
                this.createSummaryMarkdown(outDir);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating output files", (Exception)e);
        }
    }

    private void storePRDetailsIfPresent(Path outDir) throws IOException {
        Path eventJson;
        if (this.payloadPath() != null && Files.exists(eventJson = this.fs.getPath(this.payloadPath(), new String[0]), new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(eventJson, new OpenOption[0]);){
                Optional maybePayload = GithubPayload.fromEventJson((InputStream)is);
                if (maybePayload.isPresent()) {
                    this.writeGithubJson((GithubPayload)maybePayload.get(), outDir);
                }
            }
        }
    }

    private void writeGithubJson(GithubPayload payload, Path outDir) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(outDir.resolve("github-pr.json"), new OpenOption[0]);){
            writer.write(payload.asJson());
        }
    }

    private void createSummaryMarkdown(Path outDir) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(outDir.resolve("summary.md"), new OpenOption[0]);){
            this.summaryAggregator.createSummary((Collection)this.findSimplifiedJsonFiles(), this.summaryConfig(), (Writer)writer);
        }
    }

    private void aggregateSimplifiedJson(Path outDir) throws MojoExecutionException {
        try {
            this.summaryAggregator.aggregateJson((Collection)this.findSimplifiedJsonFiles(), outDir.resolve("simplified.json"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error aggregating simplified json", (Exception)e);
        }
    }

    private void aggregateAnnotationJson(Path outDir) throws MojoExecutionException {
        try {
            this.annotationAggregator.aggregateJson((Collection)this.findAnnotationsFiles(), outDir.resolve("annotations.json"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error aggregating annotation json", (Exception)e);
        }
    }

    MavenProject project() {
        return this.project;
    }

    @CoverageIgnore
    protected String payloadPath() {
        return this.githubEventPath;
    }
}

