/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.annotation;

import com.groupcdg.pitest.annotation.SourceFileLocator;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;

public class GitSourcePathDecorator
implements SourceFileLocator {
    private final Path gitRoot;
    private final List<Path> roots;
    private final SourceFileLocator child;

    GitSourcePathDecorator(Path gitRoot, List<Path> roots, SourceFileLocator child) {
        this.gitRoot = gitRoot;
        this.roots = roots;
        this.child = child;
    }

    public static GitSourcePathDecorator createFromGitLocation(Path gitRoot, int depth, SourceFileLocator child) {
        try {
            List<Path> roots = Files.find(gitRoot, depth, GitSourcePathDecorator.isDirectory(), new FileVisitOption[0]).collect(Collectors.toList());
            return new GitSourcePathDecorator(gitRoot, roots, child);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BiPredicate<Path, BasicFileAttributes> isDirectory() {
        return (p, a) -> a.isDirectory();
    }

    @Override
    public String findSourceFile(ClassName className, String filename) {
        String relative = this.child.findSourceFile(className, filename);
        return this.roots.stream().map(root -> root.resolve(relative)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(p -> this.gitRoot.relativize((Path)p).toString()).orElse(relative);
    }
}

