/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.annotation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.groupcdg.pitest.annotation.AnnotationLevel;
import com.groupcdg.pitest.annotation.SourceAnnotation;
import com.groupcdg.pitest.annotation.SourceFileLocator;
import com.groupcdg.pitest.util.Pair;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

public class SourceAnnotationListener
implements MutationResultListener {
    public static final String OUTPUT_FILE_NAME = "annotations.json";
    private final ObjectMapper mapper = new ObjectMapper();
    private final Predicate<ClassName> filter;
    private final AnnotationLevel level;
    private final Writer out;
    private final SourceFileLocator sourceLocator;
    private boolean firstResult;

    public SourceAnnotationListener(Predicate<ClassName> filter, AnnotationLevel level, ResultOutputStrategy outputStrategy, SourceFileLocator sourceLocator) {
        this(filter, level, outputStrategy.createWriterForFile(OUTPUT_FILE_NAME), sourceLocator);
    }

    public SourceAnnotationListener(Predicate<ClassName> filter, AnnotationLevel level, Writer out, SourceFileLocator sourceLocator) {
        this.filter = filter;
        this.level = level;
        this.out = out;
        this.sourceLocator = sourceLocator;
    }

    public void runStart() {
        this.firstResult = true;
        try {
            this.out.write("[");
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    public void runEnd() {
        try {
            this.out.write("]");
            this.out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    public void handleMutationResult(ClassMutationResults results) {
        try {
            Map<Pair, List<MutationResult>> byLineAndLocation = results.getMutations().stream().filter(r -> !r.getStatus().isDetected()).filter(r -> this.filter.test(r.getDetails().getClassName())).collect(Collectors.groupingBy(this::toLineLocationPair));
            List json = byLineAndLocation.entrySet().stream().map(pair -> this.toJson((Pair)pair.getKey(), (List)pair.getValue())).collect(Collectors.toList());
            if (!json.isEmpty()) {
                if (!this.firstResult) {
                    this.out.write(",\n");
                }
                this.out.write(String.join((CharSequence)",\n", json));
                this.firstResult = false;
            }
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    private Pair<Integer, MethodName> toLineLocationPair(MutationResult result) {
        return Pair.of(result.getDetails().getLineNumber(), this.extractLocation(result.getDetails()));
    }

    private MethodName extractLocation(MutationDetails details) {
        return details.getId().getLocation().getMethodName();
    }

    private String toJson(Pair<Integer, MethodName> location, List<MutationResult> results) {
        MutationResult firstMutant = results.get(0);
        String message = results.stream().map(this::makeMessage).collect(Collectors.joining("\n* ", "* ", ""));
        SourceAnnotation json = new SourceAnnotation();
        json.setFile(this.findSourceFile(firstMutant.getDetails()));
        json.setTitle(this.makeTitle(location, results));
        json.setLine(location.a());
        json.setMessage(message);
        json.setAnnotationLevel(this.level);
        return this.toJsonString(json);
    }

    private String toJsonString(SourceAnnotation json) {
        try {
            return this.mapper.writeValueAsString(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String makeTitle(Pair<Integer, MethodName> location, List<MutationResult> results) {
        String changeText = results.size() == 1 ? "A change " : "" + results.size() + " different changes ";
        return changeText + "can be made to " + this.locationText(location) + " without causing a test to fail";
    }

    private String locationText(Pair<Integer, MethodName> location) {
        String methodName = location.b().name();
        if (!methodName.startsWith("lambda$")) {
            return "line " + location.a();
        }
        return "a lambda on line " + location.a();
    }

    private String makeMessage(MutationResult result) {
        return result.getDetails().getDescription() + " (" + result.getNumberOfTestsRun() + " tests run " + this.cleanMutatorName(result.getDetails().getMutator()) + ")";
    }

    private String cleanMutatorName(String mutator) {
        return ClassName.fromString((String)mutator).getNameWithoutPackage().asJavaName();
    }

    private String findSourceFile(MutationDetails mutation) {
        return this.asUnix(this.sourceLocator.findSourceFile(mutation.getClassName(), mutation.getFilename()));
    }

    private String asUnix(String path) {
        return path.replace(File.separatorChar, '/');
    }
}

