/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import com.groupcdg.pitest.git.FilenameToPackageMapper;
import com.groupcdg.pitest.git.GitFilter;
import com.groupcdg.pitest.git.GitHandle;
import com.groupcdg.pitest.git.GitRef;
import com.groupcdg.pitest.git.GitToPackageMapper;
import com.groupcdg.pitest.git.MutantLocation;
import com.groupcdg.pitest.git.RepoRootFinder;
import com.groupcdg.pitest.git.Scope;
import com.groupcdg.pitest.licence.Licence;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;
import org.pitest.util.Glob;
import org.pitest.util.Log;

public final class GitInterceptorFactory
implements MutationInterceptorFactory {
    private static final Logger LOG = Log.getLogger();
    public static final int DEFAULT_BACK_STEPS = 2;
    private static final FeatureParameter FROM = FeatureParameter.named((String)"from").withDescription("Analyse commits since this ref or branch");
    private static final FeatureParameter TO = FeatureParameter.named((String)"to").withDescription("Analyse up to this ref of branch. Defaults to analysing uncommitted changes.");
    private static final FeatureParameter SCOPE = FeatureParameter.named((String)"scope").withDescription("Limit analysis to changed classes or lines with CLASS or LINE (default)");
    private static final FeatureParameter DIRECTORY_STEPS = FeatureParameter.named((String)"maxSteps").withDescription("Max number of directories to ascending looking for a git repo.");
    private final Clock clock;
    private final Path workingDir;

    public GitInterceptorFactory() {
        this(Paths.get("", new String[0]).toAbsolutePath(), Clock.systemUTC());
    }

    GitInterceptorFactory(Path workingDir, Clock clock) {
        this.workingDir = workingDir;
        this.clock = clock;
    }

    public String description() {
        return "Git filter";
    }

    public Feature provides() {
        return Feature.named((String)"GIT").withOnByDefault(false).withDescription("Limits mutation by git commit").withParameter(FROM).withParameter(TO).withParameter(SCOPE);
    }

    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        int maxSteps = params.getInteger(DIRECTORY_STEPS).orElse(2);
        RepoRootFinder rootFinder = new RepoRootFinder(this.workingDir, maxSteps);
        Licence licence = this.checkLicence(rootFinder);
        GitRef since = params.getString(FROM).map(GitRef::fromString).orElse(GitRef.HEAD);
        GitRef to = params.getString(TO).map(GitRef::fromString).orElse(GitRef.LOCAL);
        Scope scope = params.getString(SCOPE).map(Scope::fromString).orElse(Scope.LINE);
        LOG.info("Analysing " + since + " vs " + to + " at " + (Object)((Object)scope) + " scope.");
        Optional<Git> maybeGit = rootFinder.findGit();
        FilenameToPackageMapper mapper = FilenameToPackageMapper.makeForTargets(params.data().getTargetClassesFilter(), params.data().getClassPath());
        Predicate<MutantLocation> predicate = maybeGit.map(git -> this.makePredicate(this.findChanges((Git)git, licence, params.data().getSourceDirs(), mapper, since, to), scope)).orElse(l -> true);
        return new GitFilter(predicate);
    }

    private Set<MutantLocation> findChanges(Git git, Licence licence, Collection<File> codePaths, FilenameToPackageMapper fileMapper, GitRef since, GitRef to) {
        GitToPackageMapper mapper = new GitToPackageMapper(new GitHandle(git), this.toRelativePathStrings(git.getRepository().getDirectory(), codePaths), fileMapper);
        Set<MutantLocation> modified = mapper.findChangedLocations(since, to);
        Set<ClassName> affectedClasses = this.modifiedClasses(modified);
        LOG.info("Found " + modified.size() + " changes in " + affectedClasses.size() + " classes.");
        LOG.fine(() -> "Classes modified in this module were [" + affectedClasses.stream().map(ClassName::asJavaName).collect(Collectors.joining(",")) + "]");
        Set<MutantLocation> licenced = modified.stream().filter(this.isLicenced(licence)).collect(Collectors.toSet());
        if (licenced.size() != modified.size()) {
            LOG.warning("Some modified classes not in licenced package and will be ignored.");
        }
        return licenced;
    }

    private Predicate<MutantLocation> makePredicate(Set<MutantLocation> changes, Scope scope) {
        switch (scope) {
            case LINE: {
                return changes::contains;
            }
            case CLASS: {
                return this.classOnlyFilter(changes);
            }
        }
        throw new IllegalStateException("Unknown scope " + (Object)((Object)scope));
    }

    private Predicate<MutantLocation> classOnlyFilter(Set<MutantLocation> changes) {
        Set<ClassName> changedClasses = this.modifiedClasses(changes);
        return l -> changedClasses.contains(l.className());
    }

    private Set<ClassName> modifiedClasses(Set<MutantLocation> modified) {
        return modified.stream().map(MutantLocation::className).collect(Collectors.toSet());
    }

    private Collection<String> toRelativePathStrings(File root, Collection<File> files) {
        String sharedRoot = this.sharedRoot(root);
        if (files == null) {
            return Collections.emptyList();
        }
        return files.stream().map(this::asCanonicalPath).map(s -> s.replace(sharedRoot, "")).collect(Collectors.toList());
    }

    private String sharedRoot(File root) {
        String sharedRoot = this.asCanonicalPath(root.getParentFile());
        if (!sharedRoot.endsWith(File.separator)) {
            sharedRoot = sharedRoot + File.separator;
        }
        return sharedRoot;
    }

    private String asCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not convert " + file + " to canonical path");
        }
    }

    private Predicate<MutantLocation> isLicenced(Licence licence) {
        Collection globs = Glob.toGlobPredicates(licence.packages());
        return location -> globs.stream().anyMatch(g -> g.test(location.className().asJavaName()));
    }

    private Licence checkLicence(RepoRootFinder repoFinder) {
        return Licence.findAndCheckLicence(this.clock, this.workingDir, repoFinder);
    }
}

