/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import java.util.Objects;

public final class SourceLocation {
    private final String filename;
    private final int lineStart;
    private final int lineEnd;

    private SourceLocation(String filename, int lineStart, int lineEnd) {
        this.filename = Objects.requireNonNull(filename);
        this.lineStart = lineStart;
        this.lineEnd = lineEnd;
    }

    public static SourceLocation of(String filename, int start, int end) {
        return new SourceLocation(filename, start, end);
    }

    public String filename() {
        return this.filename;
    }

    public int startLine() {
        return this.lineStart;
    }

    public int endLine() {
        return this.lineEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.lineStart == that.lineStart && this.lineEnd == that.lineEnd && this.filename.equals(that.filename);
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.lineStart, this.lineEnd);
    }

    public String toString() {
        return this.filename + " " + this.lineStart + " to " + this.lineEnd;
    }
}

