/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.licence;

import com.groupcdg.pitest.licence.EmbeddedResourceSource;
import com.groupcdg.pitest.licence.LicenceType;
import com.groupcdg.pitest.licence.PathFinder;
import com.groupcdg.pitest.licence.ResourceSource;
import com.groupcdg.pitest.licence.WorkingDirLicenceSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.time.Clock;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.util.Log;

public final class Licence {
    private static final Logger LOG = Log.getLogger();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private final LocalDate expires;
    private final LicenceType type;
    private final List<String> packages;

    Licence(LocalDate expires, LicenceType type, List<String> packages) {
        this.expires = expires;
        this.type = type;
        this.packages = packages;
    }

    public static Licence findAndCheckLicence(Clock clock, Path workingDir, PathFinder repoFinder) {
        Licence licence = Licence.findLicence(new WorkingDirLicenceSource(workingDir, repoFinder.findPath()));
        LocalDate now = LocalDate.now(clock);
        LocalDate failDate = licence.expires().plusMonths(1L);
        LOG.info(licence.describe());
        if (now.isAfter(failDate)) {
            throw new RuntimeException("Licence expired on " + licence.expires() + " and grace period ended.");
        }
        if (now.isAfter(licence.expires())) {
            LOG.severe("Licence expired on " + licence.expires() + ". Please renew licence or build will start to fail on " + failDate);
        }
        return licence;
    }

    public static Licence findLicence(ResourceSource source) {
        return Licence.loadLicence(source, "cdg-pitest-licence.txt").orElseGet(Licence::demoLicence);
    }

    public LocalDate expires() {
        return this.expires;
    }

    public LicenceType type() {
        return this.type;
    }

    public List<String> packages() {
        return Collections.unmodifiableList(this.packages);
    }

    public String describe() {
        return "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> \n" + this.type().description() + "\nExpires: " + this.expires() + "\nFor use with packages: " + String.join((CharSequence)", ", this.packages()) + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> \n";
    }

    public static Licence demoLicence() {
        LOG.warning("Using demo licence");
        return Licence.loadLicence(new EmbeddedResourceSource(), "demo-cdg-pitest-licence.txt").orElseThrow(() -> new IllegalStateException("Demo licence not found"));
    }

    private static Optional<Licence> loadLicence(ResourceSource source, String resource) {
        return source.find(resource).map(Licence::streamToLicence);
    }

    private static Licence streamToLicence(InputStream stream) {
        try {
            Properties props = new Properties();
            props.load(stream);
            Licence.checkSignature(Licence.asMap(props));
            return Licence.makeLicence(props);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Licence makeLicence(Properties props) {
        List<String> packages = Licence.fromCommaSeparated(props.getProperty("packages"));
        LicenceType type = LicenceType.valueOf(props.getProperty("type").toUpperCase());
        return new Licence(LocalDate.parse(props.getProperty("expires"), DATE_FORMATTER), type, packages);
    }

    private static List<String> fromCommaSeparated(String list) {
        return Arrays.stream(list.split(",")).collect(Collectors.toList());
    }

    private static void checkSignature(Map<String, String> values) {
        String data = Licence.dataWithoutSignature(values);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Licence.decode(Licence.encodedPublicKey()));
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initVerify(publicKey);
            sig.update(data.getBytes(StandardCharsets.UTF_8));
            if (!sig.verify(Licence.getSignatureBytes(values))) {
                throw new RuntimeException("Invalid licence file");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String encodedPublicKey() {
        return "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN7xxTpwIhc3m1qj9Uhr04BGeLHbGIK/C2KSJ7TcYK168/2jTUbOzvjeLStOCTvnCwdkUxx3yBuNtCCXHaW4X7tXyyz4973v66L5UEQwqt4OtAaBthIdKjzy8W1qVqt3jRtEAxbwfiWA33wN2ldJbL5bCKLAlgHQ6ZmZAa1b9vGwIDAQAB";
    }

    private static byte[] decode(String key) {
        return Base64.getDecoder().decode(key.getBytes(StandardCharsets.UTF_8));
    }

    private static String dataWithoutSignature(Map<String, String> values) {
        return values.entrySet().stream().filter(pair -> !((String)pair.getKey()).equals("signature")).sorted(Map.Entry.comparingByKey()).map(pair -> (String)pair.getKey() + ":" + (String)pair.getValue()).collect(Collectors.joining("\n"));
    }

    private static byte[] getSignatureBytes(Map<String, String> values) {
        String encoded = values.get("signature");
        return Base64.getDecoder().decode(encoded);
    }

    private static Map<String, String> asMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value.toString())));
        return map;
    }
}

