/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.licence;

import com.groupcdg.pitest.licence.PathFinder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Logger;
import org.pitest.util.Log;

public class LicencePathFinder
implements PathFinder {
    private static final Logger LOG = Log.getLogger();
    private final int maxBackSteps;
    private final Path start;

    public LicencePathFinder(Path start, int maxBackSteps) {
        this.start = start;
        this.maxBackSteps = maxBackSteps;
    }

    @Override
    public Optional<Path> findPath() {
        Optional<Path> repo = this.findLicence(this.start, 0);
        if (!repo.isPresent()) {
            LOG.warning("No licence at " + this.start + " or its " + this.maxBackSteps + " parent folders.");
        }
        return repo;
    }

    private Optional<Path> findLicence(Path dir, int level) {
        if (level > this.maxBackSteps) {
            return Optional.empty();
        }
        Path licence = dir.resolve("cdg-pitest-licence.txt");
        if (Files.exists(licence, new LinkOption[0])) {
            return Optional.of(licence);
        }
        return this.findLicence(dir.getParent(), level + 1);
    }
}

