/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.summary.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.groupcdg.pitest.summary.json.SimplifiedClassResult;
import com.groupcdg.pitest.summary.json.SimplifiedResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;

public class Serializer {
    final ObjectMapper mapper = new ObjectMapper();

    public String serialize(ClassMutationResults r) {
        try {
            List<SimplifiedResult> results = r.getMutations().stream().map(this::asSimpleBean).collect(Collectors.toList());
            return this.mapper.writeValueAsString(new SimplifiedClassResult(results));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SimplifiedClassResult> deserializeList(InputStream is) {
        try {
            return this.mapper.readValue(is, new TypeReference<List<SimplifiedClassResult>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassMutationResults deserialize(String r) {
        try {
            SimplifiedClassResult cr = this.mapper.readValue(r, SimplifiedClassResult.class);
            return this.simpleResultToResult(cr);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassMutationResults simpleResultToResult(SimplifiedClassResult cr) {
        List mutants = cr.getResults().stream().map(this::asMutationResult).collect(Collectors.toList());
        return new ClassMutationResults(mutants);
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    private MutationResult asMutationResult(SimplifiedResult result) {
        MutationStatusTestPair status = MutationStatusTestPair.notAnalysed((int)this.testsRunNotSupported(), (DetectionStatus)result.getStatus());
        Location location = Location.location((ClassName)ClassName.fromString((String)result.getMutatedClass()), (MethodName)MethodName.fromString((String)result.getMethodName()), (String)result.getMethodDesc());
        MutationIdentifier id = new MutationIdentifier(location, this.indexNotSupported(), result.getMutator());
        MutationDetails md = new MutationDetails(id, result.getFilename(), result.getDescription(), result.getLineNumber(), this.blockNotSupported());
        return new MutationResult(md, status);
    }

    private SimplifiedResult asSimpleBean(MutationResult result) {
        SimplifiedResult r = new SimplifiedResult();
        r.setLineNumber(result.getDetails().getLineNumber());
        r.setStatus(result.getStatus());
        r.setDescription(result.getDetails().getDescription());
        r.setFilename(result.getDetails().getFilename());
        r.setMutatedClass(result.getDetails().getClassName().asJavaName());
        r.setMutator(result.getDetails().getId().getMutator());
        r.setMethodName(result.getDetails().getMethod().name());
        r.setMethodDesc(result.getDetails().getId().getLocation().getMethodDesc());
        return r;
    }

    private int testsRunNotSupported() {
        return 0;
    }

    private int blockNotSupported() {
        return 0;
    }

    private int indexNotSupported() {
        return 0;
    }
}

