/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.aggregate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.groupcdg.pitest.annotation.SourceAnnotation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnnotationAggregator {
    private final ObjectMapper mapper = new ObjectMapper();

    public void aggregateJson(Collection<Path> annotationFiles, Path outFile) throws IOException {
        List annotations = annotationFiles.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(this::isNotEmpty).flatMap(this::toAnnotations).collect(Collectors.toList());
        try (BufferedWriter out = Files.newBufferedWriter(outFile, new OpenOption[0]);){
            out.write(this.mapper.writeValueAsString(annotations));
        }
    }

    private boolean isNotEmpty(Path path) {
        try {
            return Files.size(path) != 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<SourceAnnotation> toAnnotations(Path p) {
        Stream<SourceAnnotation> stream;
        block8: {
            BufferedReader r = Files.newBufferedReader(p);
            try {
                stream = this.mapper.readValue((Reader)r, new TypeReference<List<SourceAnnotation>>(){}).stream();
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            ((Reader)r).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((Reader)r).close();
        }
        return stream;
    }
}

