/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.annotation;

import java.util.Arrays;

public enum AnnotationLevel {
    ERROR("failure"),
    WARNING("warning"),
    INFO("notice");

    final String githubString;

    private AnnotationLevel(String githubString) {
        this.githubString = githubString;
    }

    public static AnnotationLevel fromString(String s) {
        return AnnotationLevel.valueOf(s.toUpperCase());
    }

    public static AnnotationLevel fromGithubString(String s) {
        return Arrays.stream(AnnotationLevel.values()).filter(l -> l.githubString().equalsIgnoreCase(s)).findAny().orElseThrow(() -> new IllegalStateException("Unknown level " + s));
    }

    public String githubString() {
        return this.githubString;
    }
}

