/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import com.groupcdg.pitest.git.DebugFilenameScanner;
import com.groupcdg.pitest.util.Pair;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassPath;

public class FilenameToPackageMapper {
    private final Map<String, List<ClassName>> fileNameToClass;

    private FilenameToPackageMapper(Map<String, List<ClassName>> fileNameToClass) {
        this.fileNameToClass = fileNameToClass;
    }

    public static FilenameToPackageMapper makeForTargets(Predicate<String> targets, ClassPath cp) {
        return new FilenameToPackageMapper(FilenameToPackageMapper.mapFilenames(targets, cp));
    }

    public List<ClassName> mapFileName(String fileName) {
        List<ClassName> names = this.fileNameToClass.get(fileName);
        if (names == null) {
            return Collections.emptyList();
        }
        return names;
    }

    private static Map<String, List<ClassName>> mapFilenames(Predicate<String> targets, ClassPath cp) {
        return cp.classNames().stream().filter(targets).flatMap(name -> FilenameToPackageMapper.toFileName(cp, name)).collect(Collectors.groupingBy(Pair::a, Collectors.mapping(Pair::b, Collectors.toList())));
    }

    private static Stream<Pair<String, ClassName>> toFileName(ClassPath cp, String clazz) {
        try {
            ClassName className = ClassName.fromString((String)clazz);
            Optional<String> maybeFilename = DebugFilenameScanner.fileName(cp.getClassData(className.asJavaName()));
            return maybeFilename.map(name -> Stream.of(Pair.of(FilenameToPackageMapper.constructPath(className.getPackage(), name), className))).orElseGet(() -> Stream.of(Pair.of(FilenameToPackageMapper.guessFilename(className), className)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String guessFilename(ClassName className) {
        String name = className.asInternalName();
        int endOfOuterClass = name.indexOf(36);
        if (endOfOuterClass != -1) {
            return name.substring(0, endOfOuterClass) + ".java";
        }
        return name + ".java";
    }

    private static String constructPath(ClassName classPackage, String name) {
        String pack = classPackage.asInternalName();
        if (pack.isEmpty()) {
            return name;
        }
        return pack + "/" + name;
    }
}

