/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.licence;

import com.groupcdg.pitest.licence.ResourceSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Logger;
import org.pitest.util.Log;

public class WorkingDirLicenceSource
implements ResourceSource {
    private static final Logger LOG = Log.getLogger();
    private final Path path;
    private final Optional<Path> repoRoot;

    public WorkingDirLicenceSource(Path path, Optional<Path> repoRoot) {
        this.path = path;
        this.repoRoot = repoRoot;
    }

    @Override
    public Optional<InputStream> find(String resource) {
        Optional<InputStream> inWorkingDir = this.toInputStream(this.path, resource);
        if (inWorkingDir.isPresent()) {
            return inWorkingDir;
        }
        return this.repoRoot.flatMap(p -> this.toInputStream((Path)p, resource));
    }

    private Optional<InputStream> toInputStream(Path p, String resource) {
        Path licence = p.resolve(resource);
        LOG.info("Looking for " + licence);
        if (Files.exists(licence, new LinkOption[0])) {
            LOG.info("Found " + licence);
            try {
                return Optional.of(Files.newInputStream(p.resolve(resource), new OpenOption[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }
}

