/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.annotation;

import com.groupcdg.pitest.annotation.AnnotationLevel;
import com.groupcdg.pitest.annotation.DefaultSourceFileLocator;
import com.groupcdg.pitest.annotation.GitSourcePathDecorator;
import com.groupcdg.pitest.annotation.SourceAnnotationListener;
import com.groupcdg.pitest.annotation.SourceFileLocator;
import com.groupcdg.pitest.git.RepoRootFinder;
import com.groupcdg.pitest.licence.Licence;
import com.groupcdg.pitest.licence.LicencePathFinder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;
import org.pitest.util.Glob;

public class SourceAnnotationFactory
implements MutationResultListenerFactory {
    private static final int DEFAULT_DIRECTORY_STEPS = RepoRootFinder.DEFAULT_BACK_STEPS;
    private static final FeatureParameter LEVEL = FeatureParameter.named((String)"level").withDescription("Level at which to create annotations error, warning, info");
    private static final FeatureParameter DIRECTORY_STEPS = FeatureParameter.named((String)"maxSteps").withDescription("Max number of directories to ascending looking for a git repo.");
    private final Clock clock;
    private final Path workingDir;

    public SourceAnnotationFactory() {
        this(Clock.systemUTC(), Paths.get("", new String[0]).toAbsolutePath());
    }

    public SourceAnnotationFactory(Clock clock, Path workingDir) {
        this.clock = clock;
        this.workingDir = workingDir;
    }

    public Feature provides() {
        return Feature.named((String)"gitci").withDescription("Git CI integration").withOnByDefault(true).withParameter(LEVEL);
    }

    public String name() {
        return "gitci";
    }

    public String description() {
        return "Git CI annotations plugin";
    }

    public MutationResultListener getListener(Properties props, ListenerArguments args) {
        List<Path> paths = args.data().getSourceDirs().stream().map(File::toPath).collect(Collectors.toList());
        AnnotationLevel level = args.settings().flatMap(settings -> settings.getString(LEVEL.name())).map(AnnotationLevel::fromString).orElse(AnnotationLevel.WARNING);
        int maxSteps = args.settings().flatMap(settings -> settings.getString(DIRECTORY_STEPS.name())).map(Integer::parseInt).orElse(DEFAULT_DIRECTORY_STEPS);
        LicencePathFinder licenceFinder = new LicencePathFinder(this.workingDir, maxSteps);
        Licence licence = Licence.findAndCheckLicence(this.clock, Paths.get(args.data().getReportDir(), new String[0]), this.workingDir, licenceFinder, "GIT");
        DefaultSourceFileLocator locator = new DefaultSourceFileLocator(this.workingDir, paths);
        return new SourceAnnotationListener(this.makeFilter(licence), level, args.getOutputStrategy(), this.decorateIfRequired(maxSteps, locator));
    }

    private Predicate<ClassName> makeFilter(Licence licence) {
        Collection globs = Glob.toGlobPredicates(licence.packages());
        return c -> globs.stream().anyMatch(g -> g.test(c.asJavaName()));
    }

    private SourceFileLocator decorateIfRequired(int maxSteps, SourceFileLocator locator) {
        RepoRootFinder repoFinder = new RepoRootFinder(this.workingDir, maxSteps);
        return repoFinder.findPath().map(this.rewritePathsRelativeToGitRepo(maxSteps, locator)).orElse(locator);
    }

    private Function<Path, SourceFileLocator> rewritePathsRelativeToGitRepo(int maxSteps, SourceFileLocator locator) {
        return path -> GitSourcePathDecorator.createFromGitLocation(path, maxSteps, locator);
    }
}

