/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.codechange;

import com.groupcdg.pitest.codechange.GitFilter;
import com.groupcdg.pitest.codechange.GitInterceptorFactory;
import com.groupcdg.pitest.git.MutantLocation;
import com.groupcdg.pitest.git.Scope;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Set;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.plugin.Feature;

public abstract class GitPrefilterFactory
extends GitInterceptorFactory {
    private final Feature feature;

    public GitPrefilterFactory(Path baseDir, Clock clock, Feature feature) {
        super(baseDir, clock);
        this.feature = feature;
    }

    @Override
    public Feature provides() {
        return this.feature;
    }

    @Override
    public String description() {
        return this.feature.description();
    }

    @Override
    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        Scope scope = params.getString(SCOPE).map(Scope::fromString).orElse(Scope.LINE);
        Set<MutantLocation> changes = this.findChanges(params, scope);
        if (changes == null || !changes.isEmpty()) {
            return new GitFilter(m -> true);
        }
        return new GitFilter(m -> false);
    }
}

