/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.descriptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class DescriptionImprover
implements MutationInterceptor {
    private Map<String, String> lambdaNameToNumber;
    private Set<Location> lambdas;

    public InterceptorType type() {
        return InterceptorType.MODIFY_COSMETIC;
    }

    public void begin(ClassTree classTree) {
        this.lambdas = this.findLambdaMethods(classTree);
        Map<Location, List<Location>> locationCallTree = this.createCallTree(classTree);
        this.lambdaNameToNumber = DescriptionImprover.mapLambdasToCleanNames(locationCallTree);
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> collection, Mutater mutater) {
        return collection.stream().map(this::improveLambdaDescriptions).map(this::makeSelfReferencesLessVerbose).collect(Collectors.toList());
    }

    public void end() {
    }

    private MutationDetails improveLambdaDescriptions(MutationDetails mutationDetails) {
        if (this.isLambda(mutationDetails.getId().getLocation())) {
            String method = mutationDetails.getMethod();
            String verboseName = mutationDetails.getClassName().asInternalName() + "::" + method;
            String improvedName = this.lambdaNameToNumber.get(method);
            String existingDescription = mutationDetails.getDescription();
            String improved = existingDescription.contains(verboseName) ? existingDescription.replace(verboseName, improvedName) : existingDescription + " in " + improvedName;
            return mutationDetails.withDescription(improved);
        }
        return mutationDetails;
    }

    private MutationDetails makeSelfReferencesLessVerbose(MutationDetails mutationDetails) {
        String verboseName = mutationDetails.getClassName().asInternalName() + "::";
        String description = mutationDetails.getDescription();
        if (description.contains(verboseName)) {
            return mutationDetails.withDescription(description.replace(verboseName, ""));
        }
        return mutationDetails;
    }

    private static Map<String, String> mapLambdasToCleanNames(Map<Location, List<Location>> locationCallTree) {
        HashMap<String, String> lambdaToBetterName = new HashMap<String, String>();
        for (Map.Entry<Location, List<Location>> each : locationCallTree.entrySet()) {
            Optional<Integer> firstLambdaNumber = each.getValue().stream().map(l -> l.getMethodName()).map(DescriptionImprover::lambdaNumber).min(Integer::compareTo);
            for (Location lambda : each.getValue()) {
                lambdaToBetterName.put(lambda.getMethodName(), DescriptionImprover.adjustLambdaName(lambda.getMethodName(), each.getKey(), firstLambdaNumber));
            }
        }
        return lambdaToBetterName;
    }

    private Map<Location, List<Location>> createCallTree(ClassTree classTree) {
        Map<Location, List<Location>> locationCallTree = classTree.methods().stream().collect(Collectors.toMap(MethodTree::asLocation, m -> this.findSelfDefinedLambdasCalls((MethodTree)m, classTree.name())));
        for (Location each : this.lambdas) {
            Location caller = this.findCaller(each, locationCallTree);
            List calls = locationCallTree.getOrDefault(caller, new ArrayList());
            calls.addAll((Collection)locationCallTree.get(each));
            locationCallTree.put(caller, calls);
            locationCallTree.remove(each);
        }
        return locationCallTree;
    }

    private Set<Location> findLambdaMethods(ClassTree classTree) {
        return classTree.methods().stream().filter(MethodTree::isSynthetic).filter(m -> m.rawNode().name.contains("lambda$")).map(MethodTree::asLocation).collect(Collectors.toSet());
    }

    private Location findCaller(Location lambda, Map<Location, List<Location>> locationCallTree) {
        for (Map.Entry<Location, List<Location>> each : locationCallTree.entrySet()) {
            Location lambdaWithoutDesc = Location.location((ClassName)lambda.getClassName(), (String)lambda.getMethodName(), (String)"");
            if (!each.getValue().contains(lambdaWithoutDesc)) continue;
            return each.getKey();
        }
        throw new IllegalStateException("No caller for " + lambda);
    }

    private boolean isLambda(Location loc) {
        return this.lambdas.contains(loc);
    }

    private static String adjustLambdaName(String name, Location key, Optional<Integer> firstLambdaNumber) {
        int absoluteLambdaNumber = DescriptionImprover.lambdaNumber(name);
        int relativeLambdaNumber = absoluteLambdaNumber - firstLambdaNumber.orElse(0) + 1;
        return DescriptionImprover.niceLambdaName(relativeLambdaNumber, key.getMethodName());
    }

    private List<Location> findSelfDefinedLambdasCalls(MethodTree t, ClassName clazz) {
        return t.instructions().stream().flatMap(node -> this.selfDefinedLambdaCall((AbstractInsnNode)node, clazz)).collect(Collectors.toList());
    }

    private Stream<Location> selfDefinedLambdaCall(AbstractInsnNode node, ClassName clazz) {
        if (!(node instanceof InvokeDynamicInsnNode)) {
            return Stream.empty();
        }
        InvokeDynamicInsnNode invoke = (InvokeDynamicInsnNode)node;
        return Arrays.stream(invoke.bsmArgs).filter(o -> o instanceof Handle).map(o -> (Handle)o).filter(h -> h.getOwner().equals(clazz.asInternalName())).filter(h -> h.getName().contains("lambda$")).map(h -> Location.location((ClassName)clazz, (String)h.getName(), (String)""));
    }

    private static String niceLambdaName(int relativeNumber, String parentMethod) {
        String numberString;
        switch (relativeNumber) {
            case 1: {
                numberString = "1st";
                break;
            }
            case 2: {
                numberString = "2nd";
                break;
            }
            case 3: {
                numberString = "3rd";
                break;
            }
            default: {
                numberString = relativeNumber + "th";
            }
        }
        return numberString + " lambda in " + parentMethod;
    }

    private static int lambdaNumber(String name) {
        int end = name.lastIndexOf(36);
        return Integer.parseInt(name.substring(end + 1));
    }
}

