/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.filter;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.mutators.ConditionalsBoundaryMutator;
import org.pitest.mutationtest.engine.gregor.mutators.ConstructorCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.RemoveConditionalMutator;
import org.pitest.mutationtest.engine.gregor.mutators.VoidMethodCallMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanFalseReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanTrueReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.EmptyObjectReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.NullReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.PrimitiveReturnsMutator;

class OrderByAssumedValue
implements Comparator<MutationDetails> {
    private static final Map<String, Integer> KNOWN_MUTATORS = OrderByAssumedValue.createMap();

    OrderByAssumedValue() {
    }

    @Override
    public int compare(MutationDetails a, MutationDetails b) {
        return this.valueFor(a).compareTo(this.valueFor(b));
    }

    private Integer valueFor(MutationDetails a) {
        String mutatorID = a.getId().getMutator();
        if (mutatorID.contains("mutators.rv")) {
            return 1000;
        }
        if (mutatorID.contains("mutators.experimental")) {
            return 100;
        }
        return KNOWN_MUTATORS.getOrDefault(mutatorID, 50);
    }

    private static Map<String, Integer> createMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(OrderByAssumedValue.asString(ConditionalsBoundaryMutator.class), 0);
        map.put(OrderByAssumedValue.asString(RemoveConditionalMutator.class), 0);
        map.put(OrderByAssumedValue.asString(EmptyObjectReturnValsMutator.class), 1);
        map.put(OrderByAssumedValue.asString(PrimitiveReturnsMutator.class), 1);
        map.put(OrderByAssumedValue.asString(BooleanFalseReturnValsMutator.class), 1);
        map.put(OrderByAssumedValue.asString(BooleanTrueReturnValsMutator.class), 1);
        map.put(OrderByAssumedValue.asString(NullReturnValsMutator.class), 1);
        map.put(OrderByAssumedValue.asString(VoidMethodCallMutator.class), 2);
        map.put(OrderByAssumedValue.asString(ConstructorCallMutator.class), 99);
        return map;
    }

    private static String asString(Class<? extends MethodMutatorFactory> clazz) {
        return clazz.getName();
    }
}

