/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import com.groupcdg.pitest.git.FilenameToPackageMapper;
import com.groupcdg.pitest.git.GitHandle;
import com.groupcdg.pitest.git.GitRef;
import com.groupcdg.pitest.git.GitToPackageMapper;
import com.groupcdg.pitest.git.MutantLocation;
import com.groupcdg.pitest.git.RepoRootFinder;
import com.groupcdg.pitest.git.Scope;
import com.groupcdg.pitest.licence.Licence;
import com.groupcdg.pitest.licence.LicencePathFinder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.util.Glob;
import org.pitest.util.Log;

public class GitChanges {
    private static final Logger LOG = Log.getLogger();
    private final Clock clock;
    private final Path workingDir;

    public GitChanges(Path workingDir, Clock clock) {
        this.workingDir = workingDir;
        this.clock = clock;
    }

    public Set<MutantLocation> findChanges(RepoRootFinder rootFinder, GitRef since, GitRef to, Scope scope, ReportOptions data) {
        Licence licence = this.checkLicence(data.getReportDir(), rootFinder);
        LOG.info("Analysing " + since + " vs " + to + " at " + (Object)((Object)scope) + " scope within source dirs " + data.getSourceDirs());
        Optional<Git> maybeGit = rootFinder.findGit();
        FilenameToPackageMapper mapper = FilenameToPackageMapper.makeForTargets(data.getTargetClassesFilter(), data.getClassPath());
        return maybeGit.map(git -> this.findChanges((Git)git, licence, data.getSourceDirs(), mapper, since, to)).orElse(null);
    }

    private Set<MutantLocation> findChanges(Git git, Licence licence, Collection<File> codePaths, FilenameToPackageMapper fileMapper, GitRef since, GitRef to) {
        try (GitHandle handle = new GitHandle(git);){
            GitToPackageMapper mapper = new GitToPackageMapper(handle, this.toRelativePathStrings(git.getRepository().getDirectory(), codePaths), fileMapper);
            Set<MutantLocation> modified = mapper.findChangedLocations(since, to);
            Set<ClassName> affectedClasses = this.modifiedClasses(modified);
            LOG.info("Found " + modified.size() + " changes in " + affectedClasses.size() + " classes.");
            LOG.fine(() -> "Classes modified in this module were [" + affectedClasses.stream().map(ClassName::asJavaName).collect(Collectors.joining(",")) + "]");
            Set<MutantLocation> licenced = modified.stream().filter(this.isLicenced(licence)).collect(Collectors.toSet());
            if (licenced.size() != modified.size()) {
                LOG.warning("Some modified classes not in licenced package and will be ignored.");
            }
            Set<MutantLocation> set = licenced;
            return set;
        }
    }

    private Set<ClassName> modifiedClasses(Set<MutantLocation> modified) {
        return modified.stream().map(MutantLocation::className).collect(Collectors.toSet());
    }

    private Collection<String> toRelativePathStrings(File root, Collection<File> files) {
        String sharedRoot = this.sharedRoot(root);
        if (files == null) {
            return Collections.emptyList();
        }
        return files.stream().map(this::asCanonicalPath).map(s -> s.replace(sharedRoot, "")).collect(Collectors.toList());
    }

    private String sharedRoot(File root) {
        String sharedRoot = this.asCanonicalPath(root.getParentFile());
        if (!sharedRoot.endsWith(File.separator)) {
            sharedRoot = sharedRoot + File.separator;
        }
        return sharedRoot;
    }

    private String asCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not convert " + file + " to canonical path");
        }
    }

    private Predicate<MutantLocation> isLicenced(Licence licence) {
        Collection globs = Glob.toGlobPredicates(licence.packages());
        return location -> globs.stream().anyMatch(g -> g.test(location.className().asJavaName()));
    }

    private Licence checkLicence(String reportDir, RepoRootFinder repoFinder) {
        LicencePathFinder pathFinder = new LicencePathFinder(repoFinder.start(), repoFinder.backSteps());
        return Licence.findAndCheckLicence(this.clock, Paths.get(reportDir, new String[0]), this.workingDir, pathFinder, "GIT");
    }
}

