/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.aggregate;

import com.groupcdg.pitest.summary.MutantSummaryListener;
import com.groupcdg.pitest.summary.SummaryConfig;
import com.groupcdg.pitest.summary.json.Serializer;
import com.groupcdg.pitest.summary.json.SimplifiedClassResult;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SummaryAggregator {
    private final Serializer serializer = new Serializer();

    public void createSummary(Collection<Path> jsonFiles, SummaryConfig config, Writer out) {
        this.createSummaryFromResults(this.allResults(jsonFiles), config, out);
    }

    public void createSummaryFromResults(List<SimplifiedClassResult> results, SummaryConfig config, Writer out) {
        MutantSummaryListener summary = new MutantSummaryListener(config, out);
        summary.runStart();
        this.replayListenersOnAllProjects(results, summary);
        summary.runEnd();
    }

    public void aggregateJson(Collection<Path> jsonFiles, Path outFile) throws IOException {
        try (BufferedWriter out = Files.newBufferedWriter(outFile, new OpenOption[0]);){
            out.write(this.serializer.mapper().writeValueAsString(this.allResults(jsonFiles)));
        }
    }

    private List<SimplifiedClassResult> allResults(Collection<Path> jsonFiles) {
        return jsonFiles.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(p -> this.toResults((Path)p).stream()).collect(Collectors.toList());
    }

    private List<SimplifiedClassResult> toResults(Path path) {
        List<SimplifiedClassResult> list;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                list = this.serializer.deserializeList(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error processing " + path, e);
                }
            }
            is.close();
        }
        return list;
    }

    private void replayListenersOnAllProjects(List<SimplifiedClassResult> results, MutantSummaryListener summary) {
        results.stream().map(this.serializer::simpleResultToResult).forEach(summary::handleMutationResult);
    }
}

