/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.codechange;

import com.groupcdg.pitest.codechange.GitFilter;
import com.groupcdg.pitest.git.GitChanges;
import com.groupcdg.pitest.git.GitRef;
import com.groupcdg.pitest.git.MutantLocation;
import com.groupcdg.pitest.git.RepoRootFinder;
import com.groupcdg.pitest.git.Scope;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;

public class GitInterceptorFactory
implements MutationInterceptorFactory {
    protected static final FeatureParameter FROM = FeatureParameter.named((String)"from").withDescription("Analyse commits since this ref or branch");
    protected static final FeatureParameter TO = FeatureParameter.named((String)"to").withDescription("Analyse up to this ref of branch. Defaults to analysing uncommitted changes.");
    protected static final FeatureParameter SCOPE = FeatureParameter.named((String)"scope").withDescription("Limit analysis to changed classes or lines with CLASS or LINE (default)");
    protected static final FeatureParameter DIRECTORY_STEPS = FeatureParameter.named((String)"maxSteps").withDescription("Max number of directories to ascending looking for a git repo.");
    private final Clock clock;
    private final Path workingDir;

    public GitInterceptorFactory() {
        this(Paths.get("", new String[0]).toAbsolutePath(), Clock.systemUTC());
    }

    GitInterceptorFactory(Path workingDir, Clock clock) {
        this.workingDir = workingDir;
        this.clock = clock;
    }

    public String description() {
        return "Limits mutation by git commit";
    }

    public Feature provides() {
        return Feature.named((String)"GIT").withOnByDefault(false).withDescription(this.description()).withParameter(FROM).withParameter(TO).withParameter(SCOPE).withParameter(DIRECTORY_STEPS);
    }

    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        Scope scope = params.getString(SCOPE).map(Scope::fromString).orElse(Scope.LINE);
        return new GitFilter(this.makePredicate(this.findChanges(params, scope), scope));
    }

    protected Set<MutantLocation> findChanges(InterceptorParameters params, Scope scope) {
        int maxSteps = params.getInteger(DIRECTORY_STEPS).orElse(2);
        RepoRootFinder rootFinder = new RepoRootFinder(this.workingDir, maxSteps);
        GitRef since = params.getString(FROM).map(GitRef::fromString).orElse(GitRef.HEAD);
        GitRef to = params.getString(TO).map(GitRef::fromString).orElse(GitRef.LOCAL);
        GitChanges changesClient = new GitChanges(this.workingDir, this.clock);
        return changesClient.findChanges(rootFinder, since, to, scope, params.data());
    }

    protected Predicate<MutantLocation> makePredicate(Set<MutantLocation> changes, Scope scope) {
        if (changes == null) {
            return m -> true;
        }
        switch (scope) {
            case LINE: {
                return changes::contains;
            }
            case CLASS: {
                return this.classOnlyFilter(changes);
            }
        }
        throw new IllegalStateException("Unknown scope " + (Object)((Object)scope));
    }

    private Predicate<MutantLocation> classOnlyFilter(Set<MutantLocation> changes) {
        Set<ClassName> changedClasses = this.modifiedClasses(changes);
        return l -> changedClasses.contains(l.className());
    }

    private Set<ClassName> modifiedClasses(Set<MutantLocation> modified) {
        return modified.stream().map(MutantLocation::className).collect(Collectors.toSet());
    }
}

