/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.codechange;

import com.groupcdg.pitest.git.MutantLocation;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class GitMixedFilter
implements MutationInterceptor {
    private final CoverageDatabase cd;
    private final Set<ClassName> changedClasses;
    private final Predicate<MutantLocation> predicate;
    private boolean coveredByAChangedTest = false;

    public GitMixedFilter(CoverageDatabase cd, Set<ClassName> changedClasses, Predicate<MutantLocation> predicate) {
        this.cd = cd;
        this.changedClasses = changedClasses;
        this.predicate = predicate;
    }

    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    public void begin(ClassTree clazz) {
        Collection tests = this.cd.getTestsForClass(clazz.name());
        Set testClasses = tests.stream().map(TestInfo.toDefiningClassName()).collect(Collectors.toSet());
        this.coveredByAChangedTest = testClasses.stream().anyMatch(this.changedClasses::contains);
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.coveredByAChangedTest) {
            return mutations;
        }
        return mutations.stream().filter(this::include).collect(Collectors.toList());
    }

    public void end() {
    }

    private boolean include(MutationDetails mutationDetails) {
        MutantLocation location = MutantLocation.of(mutationDetails.getClassName(), mutationDetails.getLineNumber());
        return this.predicate.test(location);
    }
}

