/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class DebugFilenameScanner {
    public static List<String> fileNames(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        Scanner s = new Scanner();
        reader.accept((ClassVisitor)s, 0);
        return s.fileNames().collect(Collectors.toList());
    }

    static class Scanner
    extends ClassVisitor {
        private String fileName;
        private String sdebug;

        Scanner() {
            super(589824);
        }

        public void visitSource(String source, String debug) {
            this.fileName = source;
            this.sdebug = debug;
        }

        Stream<String> fileNames() {
            return Stream.concat(this.fromFilename(), this.fromSmap());
        }

        private Stream<String> fromFilename() {
            if (this.fileName != null) {
                return Stream.of(this.fileName);
            }
            return Stream.empty();
        }

        private Stream<String> fromSmap() {
            if (this.sdebug == null) {
                return Stream.empty();
            }
            List<String> lines = Arrays.asList(this.sdebug.split("\\R"));
            return lines.stream().filter(l -> l.startsWith("+")).flatMap(this::lineToFilename);
        }

        private Stream<String> lineToFilename(String line) {
            String[] parts = line.split(" ");
            if (parts.length == 3) {
                return Stream.of(parts[2]);
            }
            return Stream.empty();
        }
    }
}

