/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import com.groupcdg.pitest.git.GitRef;
import com.groupcdg.pitest.git.SourceLocation;
import com.groupcdg.pitest.util.Pair;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.pitest.util.Log;

public class GitHandle
implements AutoCloseable {
    private final Git git;

    public GitHandle(Git git) {
        this.git = git;
    }

    List<SourceLocation> lineChangesBetween(GitRef from, GitRef to) {
        AbstractTreeIterator current = this.iteratorForRef(from);
        AbstractTreeIterator referenceTree = this.iteratorForRef(to);
        DiffFormatter df = new DiffFormatter(DisabledOutputStream.INSTANCE);
        try {
            df.setRepository(this.git.getRepository());
            df.setContext(0);
            df.setDetectRenames(true);
            List<SourceLocation> list = df.scan(current, referenceTree).stream().flatMap(diff -> this.toEditList(df, (DiffEntry)diff)).flatMap(this::toClassLine).collect(Collectors.toList());
            df.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    df.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Stream<SourceLocation> toClassLine(Pair<String, Edit> pair) {
        Edit edit = pair.b();
        Edit.Type type = edit.getType();
        if (type == Edit.Type.INSERT || type == Edit.Type.REPLACE) {
            return Stream.of(SourceLocation.of(pair.a(), edit.getBeginB() + 1, edit.getEndB()));
        }
        return Stream.empty();
    }

    private Stream<Pair<String, Edit>> toEditList(DiffFormatter df, DiffEntry diff) {
        try {
            return df.toFileHeader(diff).toEditList().stream().map(e -> Pair.of(diff.getNewPath(), e));
        }
        catch (IOException e2) {
            Log.getLogger().log(Level.SEVERE, "IOException while handling " + diff, e2);
            return Stream.empty();
        }
    }

    private AbstractTreeIterator iteratorForRef(GitRef ref) throws IOException {
        if (ref.equals(GitRef.LOCAL)) {
            return new FileTreeIterator(this.git.getRepository());
        }
        if (ref.equals(GitRef.EMPTY)) {
            return new EmptyTreeIterator();
        }
        if (ref.equals(GitRef.HEAD)) {
            return this.treeParserForRef("HEAD").orElse(new EmptyTreeIterator());
        }
        return this.treeParserForRef(ref.ref().get()).orElseThrow(() -> new IllegalStateException("Unknown revision " + ref));
    }

    private Optional<AbstractTreeIterator> treeParserForRef(String ref) throws IOException {
        ObjectReader reader = this.git.getRepository().newObjectReader();
        ObjectId commitId = this.git.getRepository().resolve(ref);
        if (commitId == null) {
            return Optional.empty();
        }
        try (RevWalk revWalk = new RevWalk(this.git.getRepository());){
            RevCommit commit = revWalk.parseCommit(commitId);
            Optional<AbstractTreeIterator> optional = Optional.of(new CanonicalTreeParser(null, reader, commit.getTree()));
            return optional;
        }
    }

    @Override
    public void close() {
        this.git.close();
    }
}

