/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import com.groupcdg.pitest.git.FilenameToPackageMapper;
import com.groupcdg.pitest.git.GitHandle;
import com.groupcdg.pitest.git.GitRef;
import com.groupcdg.pitest.git.MutantLocation;
import com.groupcdg.pitest.git.SourceLocation;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassName;
import org.pitest.util.Log;

public class GitToPackageMapper {
    private final Collection<String> codePaths;
    private final GitHandle git;
    private final FilenameToPackageMapper filenameMapper;
    private static final Logger LOG = Log.getLogger();

    public GitToPackageMapper(GitHandle git, Collection<String> codePaths, FilenameToPackageMapper filenameMapper) {
        LOG.fine(() -> "Mapping from code paths " + codePaths.stream().collect(Collectors.joining(", ")));
        this.codePaths = codePaths;
        this.git = git;
        this.filenameMapper = filenameMapper;
    }

    public Set<MutantLocation> findChangedLocations(GitRef from, GitRef to) {
        return this.git.lineChangesBetween(from, to).stream().peek(s -> LOG.fine(s.toString())).flatMap(this::toLocation).collect(Collectors.toSet());
    }

    private Stream<MutantLocation> toLocation(SourceLocation location) {
        return this.toClass(location.filename()).flatMap(clazz -> this.classLocations((ClassName)clazz, location));
    }

    private Stream<MutantLocation> classLocations(ClassName clazz, SourceLocation location) {
        return IntStream.range(location.startLine(), location.endLine() + 1).mapToObj(line -> MutantLocation.of(clazz, line));
    }

    private Stream<ClassName> toClass(String path) {
        return this.codePaths.stream().flatMap(stub -> this.stringToClassName(this.asUnix((String)stub), path));
    }

    private Stream<ClassName> stringToClassName(String stub, String unixPath) {
        if (!unixPath.contains(stub)) {
            return Stream.empty();
        }
        int start = unixPath.indexOf(stub) + stub.length() + 1;
        return this.filenameMapper.mapFileName(unixPath.substring(start)).stream();
    }

    private String asUnix(String stub) {
        return stub.replace(File.separatorChar, '/');
    }
}

