/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.summary;

import com.groupcdg.pitest.summary.SummaryConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.Unchecked;

public class MutantSummaryListener
implements MutationResultListener {
    private final Writer out;
    private final SummaryConfig config;
    private final Map<ClassName, Long> surviving = new HashMap<ClassName, Long>();
    private final Map<ClassName, Long> killed = new HashMap<ClassName, Long>();

    public MutantSummaryListener(SummaryConfig config, Writer out) {
        this.config = config;
        this.out = out;
    }

    public void runStart() {
    }

    public void handleMutationResult(ClassMutationResults classMutationResults) {
        long survivors = classMutationResults.getMutations().stream().filter(r -> !r.getStatus().isDetected()).count();
        long dead = classMutationResults.getMutations().stream().filter(r -> r.getStatus().isDetected()).count();
        this.surviving.putIfAbsent(classMutationResults.getMutatedClass(), 0L);
        this.killed.putIfAbsent(classMutationResults.getMutatedClass(), 0L);
        this.surviving.compute(classMutationResults.getMutatedClass(), (k, v) -> v + survivors);
        this.killed.compute(classMutationResults.getMutatedClass(), (k, v) -> v + dead);
    }

    public void runEnd() {
        if (this.noMutants()) {
            this.write("Looks good. No mutations were possible for these changes.");
        } else {
            this.runEndWithMutants();
        }
        if (!this.config.trailerText().isEmpty()) {
            this.write("\n" + this.config.trailerText());
        }
        this.closeOutput();
    }

    private void runEndWithMutants() {
        if (this.allKilled()) {
            this.write("Looks good. All " + this.killed() + " mutations in this change were killed.");
        } else {
            this.write("- Surviving mutants in this change: " + this.surviving() + "\n");
            this.write("- Killed mutants in this change: " + this.killed() + "\n");
        }
        this.write("\n|class|surviving|killed|\n");
        this.write("|---|---|---|\n");
        for (Map.Entry<ClassName, Long> entry : this.sortByMostSurvivors(this.surviving.entrySet())) {
            Long killCount = this.killed.get(entry.getKey());
            String zombie = this.zombieIfSurvivingMutants(entry.getValue());
            this.write("|" + zombie + "`" + entry.getKey().asJavaName() + "`|" + entry.getValue() + "|" + killCount + "|\n");
        }
    }

    private Iterable<? extends Map.Entry<ClassName, Long>> sortByMostSurvivors(Set<Map.Entry<ClassName, Long>> entrySet) {
        return entrySet.stream().sorted(this.byEntryValue().reversed()).collect(Collectors.toList());
    }

    private Comparator<Map.Entry<ClassName, Long>> byEntryValue() {
        return Comparator.comparingLong(Map.Entry::getValue);
    }

    private String zombieIfSurvivingMutants(Long value) {
        if (value != 0L) {
            return this.config.mutantEmoji();
        }
        return this.config.killedEmoji();
    }

    private long surviving() {
        return this.surviving.values().stream().reduce(0L, Long::sum);
    }

    private long killed() {
        return this.killed.values().stream().reduce(0L, Long::sum);
    }

    private boolean allKilled() {
        return this.surviving() == 0L && this.killed() != 0L;
    }

    private boolean noMutants() {
        return this.surviving() == 0L && this.killed() == 0L;
    }

    private void write(String msg) {
        try {
            this.out.write(msg);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    private void closeOutput() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }
}

