/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.codechange;

import com.groupcdg.pitest.codechange.GitFilter;
import com.groupcdg.pitest.codechange.GitInterceptorFactory;
import com.groupcdg.pitest.codechange.GitMixedFilter;
import com.groupcdg.pitest.git.MutantLocation;
import com.groupcdg.pitest.git.Scope;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.plugin.Feature;

public class GitMixedInterceptorFactory
extends GitInterceptorFactory {
    public GitMixedInterceptorFactory() {
        this(Paths.get("", new String[0]).toAbsolutePath(), Clock.systemUTC());
    }

    GitMixedInterceptorFactory(Path workingDir, Clock clock) {
        super(workingDir, clock);
    }

    @Override
    public Feature provides() {
        return Feature.named((String)"GIT_MIXED").withOnByDefault(false).withDescription(this.description()).withParameter(FROM).withParameter(TO).withParameter(SCOPE).withParameter(DIRECTORY_STEPS);
    }

    @Override
    public String description() {
        return "Limit mutation by git commit for tests and code";
    }

    @Override
    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        Scope scope = params.getString(SCOPE).map(Scope::fromString).orElse(Scope.LINE);
        Set<MutantLocation> changes = this.findChanges(params, scope);
        if (changes == null) {
            return new GitFilter(m -> true);
        }
        Set<ClassName> classes = changes.stream().map(l -> l.className()).collect(Collectors.toSet());
        return new GitMixedFilter(params.coverage(), classes, this.makePredicate(changes, scope));
    }
}

