/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.filter;

import com.groupcdg.pitest.filter.OrderByAssumedValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.coverage.ClassLine;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class LineFilter
implements MutationInterceptor {
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    public void begin(ClassTree classTree) {
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutants, Mutater mutater) {
        Map<ClassLine, List<MutationDetails>> byLine = mutants.stream().collect(Collectors.groupingBy(m -> m.getClassLine()));
        return byLine.entrySet().stream().flatMap(this::selectMutants).collect(Collectors.toList());
    }

    private Stream<MutationDetails> selectMutants(Map.Entry<ClassLine, List<MutationDetails>> mutants) {
        return Stream.of(this.pickMutant(mutants.getValue()));
    }

    private MutationDetails pickMutant(List<MutationDetails> mutants) {
        return mutants.stream().sorted(new OrderByAssumedValue()).findFirst().get();
    }

    public void end() {
    }
}

