/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import java.util.Optional;

public interface GitRef {
    public static final GitRef LOCAL = new GitRef(){

        public String toString() {
            return "local changes";
        }
    };
    public static final GitRef HEAD = new GitRef(){

        public String toString() {
            return "HEAD";
        }
    };
    public static final GitRef EMPTY = new GitRef(){

        public String toString() {
            return "no parent";
        }
    };

    default public Optional<String> ref() {
        return Optional.empty();
    }

    public static GitRef fromString(final String ref) {
        if (ref.equalsIgnoreCase("-local-")) {
            return LOCAL;
        }
        if (ref.equalsIgnoreCase("head")) {
            return HEAD;
        }
        if (ref.equalsIgnoreCase("-empty-")) {
            return EMPTY;
        }
        return new GitRef(){

            @Override
            public Optional<String> ref() {
                return Optional.of(ref);
            }

            public String toString() {
                return ref;
            }
        };
    }
}

