/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.git;

import com.groupcdg.pitest.licence.LicencePathFinder;
import com.groupcdg.pitest.licence.PathFinder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.pitest.util.Log;

public class RepoRootFinder
implements PathFinder {
    public static final int DEFAULT_BACK_STEPS = LicencePathFinder.MAX_BACK_STEPS;
    private static final Logger LOG = Log.getLogger();
    private final int maxBackSteps;
    private final Path start;

    public RepoRootFinder(Path start, int maxBackSteps) {
        this.start = start;
        this.maxBackSteps = maxBackSteps;
    }

    public Optional<Git> findGit() {
        return this.findPath().map(this::toGit);
    }

    @Override
    public Optional<Path> findPath() {
        Optional<Path> repo = this.findRepo(this.start, 0);
        if (!repo.isPresent()) {
            LOG.warning("No git repo at " + this.start + " or its " + this.maxBackSteps + " parent folders. Disabling git integration.");
        }
        return repo;
    }

    public Path start() {
        return this.start;
    }

    public int backSteps() {
        return this.maxBackSteps;
    }

    private Optional<Path> findRepo(Path dir, int level) {
        if (level > this.maxBackSteps || dir == null) {
            return Optional.empty();
        }
        try {
            LOG.fine("Looking for git repo at " + dir);
            Git.open(dir.toFile());
            LOG.info("Using git repo at " + dir);
            return Optional.of(dir);
        }
        catch (RepositoryNotFoundException ex) {
            return this.findRepo(dir.getParent(), level + 1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Git toGit(Path dir) {
        try {
            return Git.open(dir.toFile());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

