/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.licence;

import com.groupcdg.pitest.licence.PathFinder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Logger;
import org.pitest.util.Log;

public class LicencePathFinder
implements PathFinder {
    public static int MAX_BACK_STEPS = 12;
    private static final Logger LOG = Log.getLogger();
    private final int maxBackSteps;
    private final Path start;

    public LicencePathFinder(Path start) {
        this(start, MAX_BACK_STEPS);
    }

    public LicencePathFinder(Path start, int maxBackSteps) {
        this.start = start.toAbsolutePath();
        this.maxBackSteps = maxBackSteps;
    }

    @Override
    public Optional<Path> findPath() {
        return this.findLicencePath(this.start, 0);
    }

    private Optional<Path> findLicencePath(Path dir, int level) {
        if (level > this.maxBackSteps) {
            return Optional.empty();
        }
        if (Files.exists(dir.resolve("cdg-pitest-licence.txt"), new LinkOption[0]) || Files.exists(dir.resolve("arcmutate-licence.txt"), new LinkOption[0])) {
            return Optional.of(dir);
        }
        Path parent = dir.getParent();
        if (parent == null) {
            LOG.warning("Reached root or relative path supplied");
            return Optional.empty();
        }
        return this.findLicencePath(parent, level + 1);
    }
}

