/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.summary.json;

import com.groupcdg.pitest.summary.json.Serializer;
import java.io.IOException;
import java.io.Writer;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.Unchecked;

public class JsonListener
implements MutationResultListener {
    private final Serializer serializer = new Serializer();
    private final Writer out;
    private boolean firstResult;

    public JsonListener(Writer out) {
        this.out = out;
    }

    public void runStart() {
        this.firstResult = true;
        try {
            this.out.write("[");
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    public void handleMutationResult(ClassMutationResults results) {
        try {
            if (!this.firstResult) {
                this.out.write(",\n");
            }
            String json = this.serializer.serialize(results);
            this.out.write(json);
            this.firstResult = false;
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    public void runEnd() {
        try {
            this.out.write("]");
            this.out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }
}

