/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.testchange;

import com.groupcdg.pitest.git.GitChanges;
import com.groupcdg.pitest.git.GitRef;
import com.groupcdg.pitest.git.MutantLocation;
import com.groupcdg.pitest.git.RepoRootFinder;
import com.groupcdg.pitest.git.Scope;
import com.groupcdg.pitest.util.ConfigUpdate;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.config.ConfigurationUpdater;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;
import org.pitest.plugin.FeatureSetting;
import org.pitest.util.Log;

public class TestChangeConfigUpdater
implements ConfigurationUpdater {
    private final Clock clock;
    private final Path workingDir;
    private static final Logger LOG = Log.getLogger();
    private static final FeatureParameter FROM = FeatureParameter.named((String)"from").withDescription("Analyse commits since this ref or branch");
    private static final FeatureParameter TO = FeatureParameter.named((String)"to").withDescription("Analyse up to this ref of branch. Defaults to analysing uncommitted changes.");
    private static final FeatureParameter DIRECTORY_STEPS = FeatureParameter.named((String)"maxSteps").withDescription("Max number of directories to ascending looking for a git repo.");

    public TestChangeConfigUpdater() {
        this(Paths.get("", new String[0]).toAbsolutePath(), Clock.systemUTC());
    }

    TestChangeConfigUpdater(Path workingDir, Clock clock) {
        this.workingDir = workingDir;
        this.clock = clock;
    }

    public void updateConfig(FeatureSetting params, ReportOptions toModify) {
        ConfigUpdate.addTestSourceDirs(toModify);
        int maxSteps = params.getInteger(DIRECTORY_STEPS.name()).orElse(RepoRootFinder.DEFAULT_BACK_STEPS);
        RepoRootFinder rootFinder = new RepoRootFinder(this.workingDir, maxSteps);
        GitRef since = params.getString(FROM.name()).map(GitRef::fromString).orElse(GitRef.HEAD);
        GitRef to = params.getString(TO.name()).map(GitRef::fromString).orElse(GitRef.LOCAL);
        GitChanges changesClient = new GitChanges(this.workingDir, this.clock);
        Set<MutantLocation> changes = changesClient.findChanges(rootFinder, since, to, Scope.CLASS, toModify);
        if (changes == null) {
            throw new IllegalStateException("In changed test mode, but no git repo found.");
        }
        List<Predicate<String>> modifiedClasses = this.modifiedClasses(changes);
        LOG.info("Limiting analysis to modified tests for licenced packages only. " + modifiedClasses.size() + " classes (generated from files in both test and production source trees) will be examined for tests.");
        toModify.setFailWhenNoMutations(false);
        Collection existingExclusions = toModify.getExcludedTestClasses();
        ArrayList<Predicate> exclusions = new ArrayList<Predicate>(existingExclusions);
        exclusions.add(Prelude.or(modifiedClasses).negate());
        toModify.setExcludedTestClasses(exclusions);
    }

    public Feature provides() {
        return Feature.named((String)"git_test").withOnByDefault(false).withDescription(this.description()).withParameter(FROM).withParameter(TO).withParameter(DIRECTORY_STEPS);
    }

    public String description() {
        return "Mutate only code covered by changed tests.";
    }

    private List<Predicate<String>> modifiedClasses(Set<MutantLocation> modified) {
        return modified.stream().map(MutantLocation::className).distinct().map(this::asPredicate).collect(Collectors.toList());
    }

    private Predicate<String> asPredicate(ClassName className) {
        return s -> s.equals(className.asJavaName());
    }
}

